#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "proctitle.c,v 1.1.1.1 1995/06/16 17:42:42 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Set the process title via resetting the ARGV
 */

#include "sos.h"

#define MAXPROCLEN 2048

static char *ProcStart = NULL;
static char *MyProgram;
static int ProcLen;


/*
 * Initialize everything: make copies of the argv and environment for
 * the program to play with, and keep the process environment free
 * to mess with.
 */
int
sos_initProcTitle(int argc, char ***argv, char ***envp, char **program)
{
  int tmp;
  char **Argv;
  int envc;
  char **Envp;

  ProcStart = **argv;

  /* Some error checking */
  if (argc < 0 || !argv || !*argv || !envp || !*envp)
    {
      return (-1);
    }

  /* Count number of environment entries */
  for(envc=0;(*envp)[envc];envc++) ;

  /* Get the new argv */
  if ((Argv = (char **)malloc(sizeof(char *) * argc)) == NULL)
    {
      return (-1);
    }

  /* Get the new envp */
  if ((Envp = (char **)malloc(sizeof(char *) * envc)) == NULL)
    {
      return (-1);
    }

  /* Copy the argv */
  for(tmp = 0;tmp < argc; tmp++)
    {
      Argv[tmp] = strdup((*argv)[tmp]);
      if (!Argv[tmp]) return(-1);
    }
  Argv[tmp] = NULL;

  /* Copy the Envp */
  for(tmp = 0;tmp < envc; tmp++)
    {
      /* XXX - should we censor anything */
      Envp[tmp] = strdup((*envp)[tmp]);
      if (!Envp[tmp]) return(-1);
    }
  Envp[tmp] = NULL;

  /*
   * XXX - This seems very system dependent--does everyone lay the process
   * environment out in the same fashion?
   */
  ProcLen = ((*envp)[envc-1] + strlen((*envp)[envc-1])) - ProcStart;

  /* Try to fool ps */
  for(tmp=1;tmp<argc;tmp++)
    (*argv)[tmp] = NULL;
  for(tmp=0;tmp<envc;tmp++)
    (*envp)[tmp] = NULL;

  *argv = Argv;
  *envp = Envp;
  environ = Envp;

  /* Get program name without location information */
  MyProgram = strrchr(Argv[0], '/');
  if (!MyProgram)
    MyProgram = Argv[0];
  else
    MyProgram++;
  MyProgram = strdup(MyProgram);
  if (!MyProgram) return(-1);

  if (program)
    *program = MyProgram;
  
  return(0);
}



/*
 * Set the process title (e.g. so that ps can see internal program state)
 */
int
sos_setProcTitle(char *fmt, ...)
{
  char buf[MAXPROCLEN];
  va_list args;
  int ret;
  char *t = buf;

  sprintf(t, "%s: ", MyProgram);
  t += strlen(t);

  va_start(args, fmt);
  ret = vsprintf(t, fmt, args);
  va_end(args);

  memset(ProcStart, ' ', ProcLen);
  strncpy(ProcStart, buf, MIN(ProcLen, strlen(buf)));
  ProcStart[MIN(ProcLen, strlen(buf))] = '\0';

  return(ret);
}

