#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "get_conn.c,v 1.1.1.1 1995/06/16 17:42:44 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Connect to authentication server
 */

#include "sos.h"


int
sos_get_conn(struct in_addr *intf, int port, int socopts, struct sos_conninfo *info)
{
  struct sockaddr_in sin;
  int sock;
  int one=1;

  sin.sin_family = AF_INET;

  /* Get a socket */
  if ((sock = socket(sin.sin_family, SOCK_STREAM, 0)) < 0)
    {
      /* XXX log */
      return(sock);
    }

  /* Set options, if requested */
  if (socopts)
    if (setsockopt(sock, SOL_SOCKET, socopts, (char *)&one, sizeof(one)) < 0)
      {
	/* XXX - log */
	close(sock);
	sock = -1;
	return(sock);
      }

  /* Initialize the socket address */
  memset((void *)&sin,0,sizeof(sin));
  sin.sin_port = htons(port);
  if (intf)
    {				/* Bind to a specific interface */
      memcpy((void *)&(sin.sin_addr),(void *)intf,sizeof(struct in_addr));
    }
  else
    {				/* Bind to all interfaces */
      sin.sin_addr.s_addr = INADDR_ANY;
    }

  /* Bind the socket */
  if (bind(sock, (struct sockaddr *)&sin, sizeof(sin)) < 0)
    {
      /* XXX - log */
      close(sock);
      sock = -1;
      return(sock);
    }

  if (listen(sock, 9) < 0)
    {
      /* XXX - log */
      close(sock);
      sock = -1;
      return(sock);
    }

  if (info)
    {
      memset((void *)info,0,sizeof(struct sos_conninfo));
      info->port = port;
      info->fd = sock;
    }

  return(sock);
}
