#if !defined(lint) && !defined(__INSIGHT__)
static char sos__rcsid[] = "alloc.c,v 1.1.1.1 1995/06/16 17:42:40 seth Exp";
static char sos__copyright[] = "Copyright (c) 1994, 1995 SOS Corporation";
static char sos__contact[] = "SOS Corporation <sos-info@soscorp.com> +1 800 SOS UNIX";
#endif /* not lint */

/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Memory allocation stuff for sos_strings
 */

#include "sos.h"

sos_string *sos_allocstr(sos_string *buf, int size)
{
  if (size < 1)
    {
      errno = EINVAL;
      return NULL;
    }

  if (!buf)
    buf = (sos_string *)malloc(sizeof(sos_string));

  if (!buf)
    return NULL;

  buf->len = size;
  buf->str = (char *)malloc(size);

  if (!buf->str)
    return NULL;

  return buf;
}

/*
 * Free the allocated string
 * XXX - note will NOT free the actual sos_string
 * even though we might have created it above
 */
void sos_freestr(sos_string *buf)
{
  if (buf->str)
    {
      free(buf->str);
    }
  buf->len = 0;
  buf->str = NULL;
}
