/*
 * ++Copyright Released Product++
 *
 * Copyright (c) 1994, 1995 Sources of Supply Corporation ("SOS").
 * All rights reserved.
 *
 * The SOS Released Product License Agreement specifies the terms and
 * conditions for redistribution.  You may find the License Agreement
 * in the file LICENSE.
 *
 * SOS Corporation
 * 461 5th Ave.; 16th floor
 * New York, NY 10017
 *
 * +1 800 SOS UNIX
 * <sos-info@soscorp.com>
 *
 * --Copyright Released Product--
 */

/*
 * Unix declarations
 *
 * Standard include files plus definitions the OS did not see fit to include
 */

#ifndef _bs_unix_decl_h
#define _bs_unix_decl_h

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>
#include <signal.h>
#include <time.h>
#include <stdarg.h>
#include <string.h>
#include <syslog.h>
#include <netdb.h>
#include <limits.h>
#include <fcntl.h>
#include <termios.h>
#include <memory.h>

#include <sys/time.h>
#include <sys/socket.h>
#include <sys/stat.h>
#include <sys/uio.h>
#include <sys/wait.h>
#include <sys/param.h>
#include <sys/filio.h>
#include <sys/resource.h>

#include <netinet/in.h>

#include <arpa/inet.h>

/* CLC routines */
#include "dict.h"
#include "dll.h"
#include "ht.h"
#include "pq.h"


/*********************************************************************
 *                              SunOS                                *
 *********************************************************************/
#if defined(__sun__) && !defined(__svr4__)

#include <malloc.h>
#include <sys/vfs.h>

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern char *rindex(char *s, char c);
extern char *memalign(unsigned alignment, unsigned size);
extern char *crypt(const char *, const char *);
extern char *strerror(int errno);
extern int getpeername(int, struct sockaddr *, int *);
extern int getsockname(int, struct sockaddr *, int *);

/* STATFS stuff */
typedef long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;
#define SOS_STATFS statfs		/* Actuall text for call */
#define SOS_FSTATFS fstatfs		/* Actuall text for call */
#define SOS_FSIZE(s) ((s).f_bsize)		/* Fundamental block size */
#define SOS_FINODE(s) ((s).f_ffree)		/* Free inodes (non-super if filled) */

#endif /* SUNOS */


/*********************************************************************
 *                             Solaris                               *
 *********************************************************************/
#if defined(__sun__) && defined(__svr4__)

#include <sys/sysmacros.h>
#include <sys/statvfs.h> /* Use statvfs as statfs is a compat header */

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern char *crypt(const char *, const char *);

/* STATFS stuff */
typedef ulong sos_fslong_t;
typedef struct statvfs sos_tmpstatfs;
#define SOS_STATFS statvfs
#define SOS_FSTATFS fstatvfs
#define SOS_FSIZE(s) ((s).f_frsize)
#define SOS_FINODE(s) ((s).f_favail)

#endif /*SOLARIS*/


/*********************************************************************
 *                               HPUX                                *
 *********************************************************************/
#if defined(__hpux__)

#define memalign(x,y) malloc(y)

extern char **environ;

/*
 * There is no way to fix this correctly unfortunately.
 * HPUX 9.01 declares fd_set and such in header files, but the select()
 * system call seems to want an int, according to the man page select(2).
 * Furthermore, the header files for HPUX-9.01 don't even prototype the
 * syscall, but set it as "extern int select()".  HP's fault.
 */
extern int select();

/* STATFS stuff */
typedef long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;
#define SOS_STATFS statfs
#define SOS_FSTATFS fstatfs
#define SOS_FSIZE(s) ((s).f_bsize)
#define SOS_FINODE(s) ((s).f_ffree)

#endif /*HPUX*/


/*********************************************************************
 *                               BSDI                                *
 *********************************************************************/
#if defined(__bsdi__)

#include <sys/mount.h>

#define memalign(x,y) malloc(y)

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern time_t timelocal(struct tm * const tmp);

/* STATFS stuff */
typedef long sos_fslong_t;
typedef struct statfs sos_tmpstatfs;
#define SOS_STATFS statfs
#define SOS_FSTATFS fstatfs
#define SOS_FSIZE(s) ((s).f_fsize)
#define SOS_FINODE(s) ((s).f_ffree)

#endif /* BSDI */


/*********************************************************************
 *                               IRIX                                *
 *********************************************************************/
#if defined(__sgi__)

#include <sys/statvfs.h> /* Use statvfs as statfs is a compat header */

extern char **environ;

extern char *inet_ntoa(struct in_addr in);
extern char *crypt(const char *, const char *);

/* STATFS stuff -- Perhaps this should be moved to sgi&&svr4?  */
typedef ulong_t sos_fslong_t;
typedef struct statvfs sos_tmpstatfs;
#define SOS_STATFS statvfs
#define SOS_FSTATFS fstatvfs
#define SOS_FSIZE(s) ((s).f_frsize)
#define SOS_FINODE(s) ((s).f_favail)

#endif /* IRIX */


/*********************************************************************
 *                               MISC                                *
 *********************************************************************/
#ifndef _INTERRUPT_SYSCALLS_
#define _INTERRUPT_SYSCALLS_ 0
#endif /* _INTERRUPT_SYSCALLS_ */


#ifndef _POSIX_ARG_MAX
#define _POSIX_ARG_MAX 4096
#endif /*!_POSIX_ARG_MAX*/


#if defined(__sgi__) || defined(__svr4__)

#define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) { sa_flags, sa_handler, sa_mask }

#else /* Everything else */

#define SIGACTIONDEFINE(sa_handler, sa_mask, sa_flags) { sa_handler, sa_mask, sa_flags }

#endif /* SIGACTION STUFF */


#endif				/*!_bs_unix_decl_h */

