######################################################################
##
##		     SOS Master Makefile Template
##
######################################################################


######################################################################
##
## OS Dependant directores
##
override ARCH_DIR = $(shell uname -s | tr / - )-$(shell uname -r)-$(shell uname -m | tr / - )
override OS_TYPE = $(shell uname -s | tr / - )-$(shell uname -r)

export ARCH_DIR OS_TYPE

######################################################################
##
## OS Specific directives
##
ifeq ($(OS_TYPE),SunOS-4.1.3_U1)
########################################
# SunOS
#
OS_LIBS=-lresolv -l44bsd
OS_FLAGS=-D_INTERRUPT_SYSCALLS_=SA_INTERRUPT
OS_LDFLAGS=
OS_STATIC=-static
SID_OS_EXT=-SUNOS
SID_OS_DIR=sun
OS_EXT=
RANLIB=ranlib
########################################
else
ifeq ($(OS_TYPE),IRIX-5.3)
########################################
# IRIX
#
##############################
# IRIX cc (debugging)
#
#CC=cc
#OS_FLAGS=-D_NEWTIME -D__sgi__ '-D__SIZE_TYPE__=unsigned int' -Dalloca=__builtin_alloca
#OS_LDFLAGS=-L/usr/local/gnu/lib
##############################
# IRIX gcc (no debugging)
#
OS_FLAGS=-D_NEWTIME
OS_LDFLAGS=
########################################
# IRIX non-specific
#
OS_LIBS=-lresolv -l44bsd
SID_OS_EXT=-IRIX-5.3
SID_OS_DIR=sgi5
OS_EXT=
RANLIB=:
########################################
else
ifeq ($(OS_TYPE),BSD-386-1.1)
########################################
# BSDI
#
OS_LIBS=-lresolv
OS_FLAGS=
OS_LDFLAGS=
OS_EXT=
RANLIB=ranlib
TCL_LINC=-L$(TCL_LDIR) -L/usr/X11/lib
TCL_INCLUTCL=-I$(TCL_INCDIR) -I/usr/X11/include
########################################
else
ifeq ($(OS_TYPE),SunOS-5.3)
########################################
# SOLARIS
#
OS_LIBS=-lresolv -lsocket -lresolv -lnsl -lresolv -l44bsd
OS_FLAGS=-D_NEWTIME
OS_LDFLAGS=
OS_EXT=
RANLIB=:
########################################
else
ifeq ($(OS_TYPE),HPUX)
########################################
# HPUX
#
#OS_LIBS=-lresolv -l44bsd
OS_LIBS=
OS_FLAGS=-D_NEWTIME -D_INCLUDE__STDC__
OS_LDFLAGS=
OS_EXT=
RANLIB=:
########################################
else
ifeq ($(OS_TYPE),LINUX)
########################################
# LINUX
#
OS_LIBS=-lresolv -l44bsd
OS_FLAGS=-D_NEWTIME
OS_LDFLAGS=
OS_EXT=
RANLIB=:
########################################
endif # Linux
endif # HPUX
endif # SOLARIS
endif # BSDI
endif # IRIX
endif # SUNOS

######################################################################
##
## Encryption
##



######################################################################
##
## Compiler variables
##
ifeq ($(USING_INSIGHT),true)
CC=insight
else
CC=gcc
endif

LEX=flex
YACC=bison -d
UMASK=:
INSTALL=install
INSTALL_BINFLAGS=-m 775
INSTALL_OTHERFLAGS=-m 664
MKDEP=$(CPP) -M $(CFLAGS)




########################################
# C
COPTDEBUG=-g -O -Werror
#COPTDEBUG=-g
#COPTDEBUG=-O2

COMMON_DEFINES=-D__STDC__ $(OS_FLAGS)
COMMON_INCLUDES=-I$(SOS)/include -I/usr/local/include
COMMON_LDS=-L$(SOS)/lib/lib.$(ARCH_DIR) $(OS_LDFLAGS) -L/usr/local/lib
COMMON_LIBS=$(OS_LIBS) -lz

ifneq ($(strip $(WANT_SOS_LIBS)),)
SOS_LDS=
SOS_LIBS=-lesos -ldict -lfsma -lpq -lmd5 $(ENCRYPT_LIBS)
endif

CFLAGS=	$(COPTDEBUG) $(PRIVATE_DEFINES) $(COMMON_DEFINES) ${STANDARD_DEFINES} $(LOCAL_DEFINES) \
	$(PRIVATE_INCLUDES) $(COMMON_INCLUDES) ${STANDARD_INCLUDES} ${LOCAL_INCLUDES} 
LDFLAGS=$(PRIVATE_LDS) $(SOS_LDS) ${STANDARD_LDS} $(COMMON_LDS) ${LOCAL_LDS}
LDLIBS=$(PRIVATE_LIBS) $(SOS_LIBS) $(STANDARD_LIBS) ${COMMON_LIBS} ${LOCAL_LIBS}

VPATH+=$(SOS)/lib/lib.${ARCH_DIR}:/usr/local/gnu/lib:/usr/local/lib:/usr/lib

########################################
# Information for multiple-arch builds
ifneq ($(strip $(CURDIR)),)
BUILD_UPDIR=../..
vpath %.h $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
vpath %.c $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
vpath %.l $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
vpath %.y $(TOPDIR)/$(BUILD_UPDIR)/$(CURDIR)
endif


########################################
# Lex
LOPTDEBUG=
#LOPTDEBUG=-CF

LEX_LIB=-lfl
LFLAGS=$(LOPTDEBUG)


######################################################################
##
## Makefile rules
##

%.o: %.c
	$(COMPILE.c) $(OUTPUT_OPTION) $<

%.c: %.l
	$(LEX) $(LFLAGS) -t $< > $@

%.tab.c: %.y
	$(YACC) $(YFLAGS) $<

######################################################################
##
## Common targets
##

########################################
# Default target (for user to munge)
ifneq ($(strip $(NO_DEFAULT_RULE)),)
default::
else
default:: $(SIMPLE_PROGS) $(COMPLEX_PROGS) $(LIBS) $(PRIVATE_TARGETS)
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif
endif


########################################
# Simple programs
$(SIMPLE_PROGS): %: %.o $(PRIVATE_LIBS) $(STANDARD_LIBS) $(SOS_LIBS)
	$(LINK.c) -o $@ $< $(LDLIBS)

########################################
# Clean
SOS_JUNK=*.o *.a *~ core $(SIMPLE_PROGS) $(COMPLEX_PROGS) $(LIBS) tca.log tca.map .inslog _1001.out

clean::
	$(RM) $(SOS_JUNK) $(PRIVATE_JUNK) .depend
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif

neat::
	$(RM) $(SOS_JUNK) $(PRIVATE_JUNK)
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif

########################################
# Subdirectories
SUBDIRRULE=@SUBDIR="${SUBDIR}"; if [ -n "$$SUBDIR" ]; then for d in $$SUBDIR; do (cd $$d; $(MAKE) $(MFLAGS) $@); done; fi

########################################
# Dependancies
ifneq ($(strip $(OBJ)),)
depends:: $(OBJ:.o=.c)
	$(MKDEP) $^ > .depend
endif

ifneq ($(strip $(SIMPLE_PROGS)),)
depends:: $(SIMPLE_PROGS:=.c)
	$(MKDEP) $^ > .depend
endif

ifneq ($(strip $(SUBDIR)),)
depends::
	$(SUBDIRRULE)	
endif

######################################################################
# BUILD targets for multi-arch
#
ifneq ($(strip $(CURDIR)),)
build::
	-d=BUILD/$(ARCH_DIR); (echo ./Make*; find $(SUBDIR) -name Make\* -print) | while read f; do mkdir -p $$d/`dirname $$f`; ln -s `pwd`/$$f $$d/$$f; done
	@echo "To compile: cd BUILD/$(ARCH_DIR) and type make"
endif

########################################
# Install
install::
ifneq ($(strip $(SUBDIR)),)
	$(SUBDIRRULE)	
endif


######################################################################
######################################################################
# Start auto generated depenancies				     #
######################################################################
######################################################################
-include .depend

.PHONY : default clean neat depends install
