// Reprod.cpp   -> Reproduction of GP

//   10/11/93 apf

/* Genetic Programming System using the C++ programming language

 Input is of the form gp <pop> <gen> <output file>

 A Potted History:

	 Version 1.00 BETA (sometime March 1993). Very Buggy,...
	 Version 2.00 C++ version very easy language 16 July 1993
								ERRORS in load and saving a genetic program.
											 No capacity for extended memory in DOS.
											 No differing creation mechanism.
											 No touranment selection
											 No capacity for encapsulation
	 Version 3.00 C++ Version.( Uncompatible with previous versions )
											 Robust with full use of OOP techniques.
											 Compatibility with ANSI standard.
											 Ramped half and half implemented.
											 Tournament selection implemented.
											 Changing variables does not require recompiling.
											 BUT STILL
											 No capacity for expanded or extended memory in DOS.
											 No capacity for encapsulation.

	 C version in progress
	 Windows version in progress but its all gobblydegook.


	 Version 3.00 can be compiled in the DOS and UNIX domain
	 but NOT in Windows. This was not made clear in previous programs.

 Genetic programming in C++ was designed and choreographed by Adam P.Fraser

		Food parcels, cash and trashy sci-fi novels to:

					 a.fraser@eee.salford.ac.uk
					snail:
					 A.Fraser
					 PostGraduate Section,
					 Maxwell Building,
					 Elec & Elec Eng,
					 University Of Salford,
					 Salford,
					 M5 4WT.
					 England


		Your comments, improvements and complaints are welcome.


 This code is intended as a base for C++ GPers. Please if you adapt the code
 send me a msg. Also could you please keeps these comments and my address in
 the code.

							regards,
											Adam Fraser ;-)
											16 November 1993

	' and one day there shall come an artificial ant who can complete the santa
	fe trail in 400 evaluation steps and on that day there shall be oink flap'
*/


#include "gpmain.hpp"

// #define TOURNAMENT       //uncomment this to turn tournament select on

// note the beauty and elegance of this new reproduction system compared
// to the old nearly thirty line code.........

// Genetic programming should be beautiful.......

void Population::Reproduce()
{
#ifndef TOURNAMENT
	TotalFitness();  				// Must be called before probabiliy selection
#endif
	for ( int i = 0; i < NumberToReproduce; i++ )
	{
		GP *pgpBest = NULL, *pgpWorst = NULL;
#ifdef TOURNAMENT

		GP **pgpOutput;

		pgpOutput = TournamentSelect();

		pgpBest = pgpOutput[0];
		pgpWorst = pgpOutput[1];

#else

		pgpBest = ProbableBest();
		pgpWorst = ProbableWorst();

#endif

		uliFitness -= pgpWorst->iFitness;					// take away fitness of delete
		uliFitness += pgpBest->iFitness;          // add fitness of new copy

// copy function overwrites any old gp header ( clearing memory obviously )
// note we are able to select the same gp as the best and the worst soo must
// check to make sure we dont overwrite the thing we are trying to copy !!??

		if ( pgpWorst != pgpBest ) pgpWorst->Copy( pgpBest );
	}
}





