// population.hpp

// Population class definitions -> defined in pop.cpp

#ifndef __POP

#define __POP

#include "gpv.hpp"

class Population : public GP, public GPVariables
{
	unsigned long uliFitness,                 // fitness of total pop
	              uliLength,                  // total length of pop
								uliDepth;                   // total depth not used

	friend ostream& operator << ( ostream&, Population* );

public:

	Population( int = 500, int = 51 );   // defined in pop.cpp
	~Population();
	unsigned long TotalFitness();
	unsigned long TotalLength();
	unsigned long TotalDepth();
	int Compare( GP * );                      // defined in compare.cpp
	void Evaluate();															// defined in eval2.cpp
	GP* Best();                               // defined in select.cpp
	GP* Worst();
	GP* Select();
	GP* ProbableBest();
	GP* ProbableWorst();
	GP** TournamentSelect();
	void Crossover();                         // defined in crosover.cpp
	void Reproduce();                         // defined in reprod.cpp
};

#endif
