/************************************************************************
 *                                                                      *
 *               PGA - Parallel Genetic Algorithm Testbed               *
 *                                                                      *
 *           "A Parallel Implementation of a genetic algorithm"         *
 *                                                                      *
 *                By Geoffrey H. Ballinger (geoff@ed.ac.uk),            *
 *                   Peter Ross (peter@ed.ac.uk)                        *
 *                                                                      *
 ************************************************************************/

/* 
   Copyright (C) 1993, Peter Ross and Geoffrey H. Ballinger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

typedef struct genodata {     /* genotype string plus reference count    */
  char *genotype;
  int refcount;
  int id;
  int parent1, parent2;
} GENODATA;

typedef struct chromosome {   /* A chromosome consists of a genotype and */
  GENODATA *gdp;               /* a fitness.                             */
  double fitness;
} CHROMOSOME;

typedef struct chromopair {   /* Returned by crossover, contains one or */
  CHROMOSOME child1;          /* two children depending on -t flag      */
  CHROMOSOME child2;
} CHROMOPAIR;

/* If a genotype is longer than this (set by -n) then use
   a double in the decode routine, because a long will overflow.
   A long is 32 bits on most systems, so a value of 60 assumes
   that every call of decode() will be trying to split the
   genotype into at least two numbers, so won't be collecting
   up more than 30 bits at one go. */

#define CRUCIAL_GENO_SIZE 60

/* User actions possible */

#define QUIT      1
#define CONTINUE  2
#define RESTART   3
#define ASK_AGAIN 4

/* data input files */

#define WEIGHTSFILE  "weights"  /* name of file for knapsack data */
#define RRDATAFILE   "rrdata"   /* name of file for Royal Road data */
#define TTDATAFILE   "ttdata"   /* Name of file for timetable data */

/* On some operating systems you will need a different random (etc) */
#if hpux || SOLARIS
#ifdef SOLARIS
#include <stdlib.h>
#endif
#define random() lrand48()
#define srandom(seed) srand48((long) seed)
#endif hpux || SOLARIS

/******************************/
/* Timetabling-specific stuff */
/******************************/

/* The constraint types: */

enum constraint_type {
  CLASH,        /* E1 and E2 must not clash: blame E1 */
  CLASH_COPY,   /* .. but keep a copy for later info with E2 */
  BEFORE,       /* Event E must precede another: but blame E */
  EXCLUDE,      /* Event E must not be in slot S: blame E */
  PRESET        /* Event E must be in slot S: just make it so! */
};

struct constraint       {  /* used for timetable constraints of     */
  struct constraint *next; /* various sorts: e1 != e2, e1 not in s, */
  int e1;                  /* e1 must be in s, e1 must precede e2   */
  int e2;
  int s;
  double cpenalty;         /* what this constraint costs to break   */
  enum constraint_type ctype;    /* what type of constraint this is */
};

/* The following enum defines symbols for each type of entry in */
/* the timetable data file. The struct following it associates  */
/* keywords with each type, thus making it easy to add other    */
/* keywords just by adding extra lines to the struct - code     */
/* should NOT need changing.                                    */

enum entry_type {  
        END_LIST,           /* (marks end of struct array below)          */
        DATA_EVENTS,        /* Number of events is #1                     */
        DATA_SLOTS,         /* Number of slots (NOT per day) is #1        */
        DATA_DAY,           /* Total number of days is #1                 */
        DATA_SPREAD,        /* Near-clashes if <= #1 apart                */
        DATA_CLASHTYPE,     /* Clash penalties are per-student? type=1..3 */
        PENALTY_CLASH,      /* Penalty for clash is #1                    */
        PENALTY_ORDER,      /* Penalty for order violation is #1          */
        PENALTY_EXCLUDE,    /* Penalty for event in bad slot for it is #1 */
        PENALTY_NEARCLASH,  /* Penalty for near-clash is #1               */
        CONSTRAIN_CLASH,    /* Event #1 and event #2 in different slots   */
        CONSTRAIN_BEFORE,   /* Event #1 must precede event #2             */
        CONSTRAIN_EXCLUDE,  /* Event #1 must not be in slot #2            */
        CONSTRAIN_PRESET    /* Event #1 must be in slot #2                */
};

#define CHUNK 10  /* The array where numbers get stashed first will    */
                  /* increase by this size whenever necessary. MUST BE */
                  /* AT LEAST 2.                                       */
#define ALL -1    /* MUST BE NEGATIVE: means "get all numbers on line" */

struct tt_params {
  char *param;
  enum entry_type param_type;
  int args_wanted;
};

#define SLOTVAL(x) ((x)-'0')
