/* init.c

   Copyright (C) 1993, 1994 Peter Ross

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. 
*/

#include <stdio.h>            /* Include the IO and maths header files. */
#include <math.h>

#include "pga.h"              /* defines genodata and chromosome structs */

/* PGA-specific stuff */

extern int compchromo();
extern int chromo_id;
extern int ss_task;
extern int geno_size;
extern int max_allele;
extern int mcb_range;
extern double (*evaluate)();
extern double *total_abs_fitness;

/* C stuff */

extern char *malloc();
extern long random();

/************************************************************************/
/* This initialises a chromosome of random 0s and 1s and .. up to range */
/* INCLUSIVE. So range = 1 for 0s and 1s, range=2 for 0/1/2 etc         */
/************************************************************************/

void init_genotype(gdp,range)
GENODATA *gdp;
int range;
{
  int i;

  gdp->refcount = 1;
  gdp->id = chromo_id++;
  gdp->parent1 = gdp->parent2 = 0;
  gdp->genotype = (char *)malloc(geno_size+1);
  gdp->genotype[geno_size] = '\0';  /* for printing */
  for(i=0;i<geno_size;i++)
     gdp->genotype[i] = '0'+(random() % (range+1));
}

/************************************************************************/
/* This creates and randomly initialises the chromosome populations     */
/************************************************************************/

CHROMOSOME *init_pops_sorted(numpops,numchromo)
{
  int chromo,pop;
  CHROMOSOME *pops;

  pops=(CHROMOSOME *)malloc(numpops*numchromo*sizeof(CHROMOSOME));
  if(pops == (CHROMOSOME *)NULL) {
        fprintf(stderr, "Cannot get enough memory to initialise - goodbye\n");
        exit(1);
  }

  for(pop=0;pop<numpops;pop++) total_abs_fitness[pop] = 0.0;

  for(chromo=0; chromo<numpops*numchromo; chromo+=1) {  /* Initialise the */
    pops[chromo].gdp = (GENODATA *)malloc(sizeof(GENODATA)); /* pops.     */
    init_genotype(pops[chromo].gdp,max_allele);             
    pops[chromo].fitness=evaluate(pops[chromo].gdp->genotype);
    /* total_abs_fitness[n] is total fitness of population n */
    total_abs_fitness[chromo/numchromo] += fabs(pops[chromo].fitness);
  }
  if(!ss_task) { /* Don't bother sorting if it's ssgen or ssone */
    for(pop=0; pop<numpops; pop+=1) {
        qsort((char *)((int)pops+(pop*numchromo*sizeof(CHROMOSOME))),
            numchromo, sizeof(CHROMOSOME), compchromo);
    }
  }
  return(pops);
}

CHROMOSOME *init_pops_unsorted(numpops,numchromo)
{
  int chromo,pop;
  CHROMOSOME *pops;

  pops=(CHROMOSOME *)malloc(numpops*numchromo*sizeof(CHROMOSOME));
  if(pops == (CHROMOSOME *)NULL) {
        fprintf(stderr, "Cannot get enough memory to initialise - goodbye\n");
        exit(1);
  }

  for(pop=0;pop<numpops;pop++) total_abs_fitness[pop] = 0.0;

  for(chromo=0; chromo<numpops*numchromo; chromo+=1) {  /* Initialise the */
    pops[chromo].gdp = (GENODATA *)malloc(sizeof(GENODATA)); /* pops.     */
    init_genotype(pops[chromo].gdp,max_allele);             
    pops[chromo].fitness=evaluate(pops[chromo].gdp->genotype);
    /* total_abs_fitness[n] is total fitness of population n */
    total_abs_fitness[chromo/numchromo] += fabs(pops[chromo].fitness);
  }

  return(pops);
}
