#include "genocop.h"


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   read_file()                                  */
/*                                                                              */
/*           SYNOPSIS          :   void read_file(equalities,inequalities,      */
/*                                                              domains,tot_arr)*/
/*                                                                              */
/*           DESCRIPTION       :   This function reads from an input file the   */
/*                                  data and writes on the the corresponding    */
/*                                  equalities, inequalites and domain matrices.*/
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
read_file(equalities, inequalities, domains, tot_arr)
    MATRIX          equalities, inequalities, domains;
    IVECTOR         tot_arr;
{
    int             t2, i, j, total_variables;
    float           t1, t3;

    if (tot_arr[1] != 0)
	for (i = 1; i <= tot_arr[1]; i++)
	    for (j = 1; j <= tot_arr[0] + 1; j++)
		fscanf(input, " %f", &equalities[i][j]);

    if (tot_arr[2] != 0)
	for (i = 1; i <= tot_arr[2]; i++)
	    for (j = 1; j <= tot_arr[0] + 1; j++)
		fscanf(input, " %f", &inequalities[i][j]);

    for (i = 1; i <= tot_arr[0]; i++)
    {
	domains[i][1] = MIN;
	domains[i][2] = (float) i;
	domains[i][3] = MAX;
    }

    if (tot_arr[3] != 0)
	for (i = 1; i <= tot_arr[3]; i++)
	{
	    fscanf(input, " %f %d %f", &t1, &t2, &t3);
	    domains[t2][1] = t1;
	    domains[t2][3] = t3;
	}

}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   write_file()                                 */
/*                                                                              */
/*           SYNOPSIS          :   void write_file(final_mat,fin_row,fin_col,   */
/*                                                     a1_b,x1,x2,x1_row,x2_row)*/
/*                                                                              */
/*           DESCRIPTION       :   This function writes on to an output file the*/
/*                                  converted equalities, inequalites and       */
/*                                  the domains, represented with the           */
/*                                  uneliminated varables, in the format        */
/*                                  requested                                   */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
write_file(final_mat, fin, a1_b, x1, x2, x1_row, x2_row, in)
    MATRIX          final_mat;
    VECTOR          a1_b;
    IVECTOR         x1, x2;
    INDEX           fin;
    int             x1_row, x2_row, in;
{
    int             i, j, k = 1;

    fprintf(output, "Left\t\t");
    for (j = 1; j <= fin.c - 2; j++)
	fprintf(output, " X%d\t", x2[j]);
    fprintf(output, "\tRight\n");


    for (i = 1; i <= fin.r; i++)
    {
	for (j = 1; j <= fin.c; j++)
	{
	    if (((j == 2) && (i < in)) || (j == fin.c))
		fprintf(output, "\t");
	    fprintf(output, "%5.2f\t", final_mat[i][j]);
	}
	fprintf(output, "\n");
    }

    fprintf(output, "\n\n\n\n\t");


    for (j = 1; j <= fin.c - 2; j++)
	fprintf(output, " X%d\t", x2[j]);
    fprintf(output, "const\n\n");


    for (i = x2_row + 1; i <= x2_row + x1_row; i++)
    {
	fprintf(output, "X%d\t", x1[k]);
	for (j = 2; j < fin.c; j++)
	    fprintf(output, "%5.2f\t", final_mat[i][j]);
	fprintf(output, "%5.2f\n", a1_b[k++]);
    }
}

