#include "genocop.h"


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_equalities()                           */
/*                                                                              */
/*           SYNOPSIS          :   void print_equalities(equal,t_var,t_equ,     */
/*                                                                   coeff,rhs) */
/*                                                                              */
/*           DESCRIPTION       :   This function prints the matrix passed, on to*/
/*                                  the standard output, in the format of       */
/*                                  equalities.                                 */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/


void 
print_equalities(equal, t_var, t_equ, coeff, rhs)
    MATRIX          equal;		    /* the equalities matrix */
    VECTOR          rhs;		    /* the right hand side of the
					     * equalities */
    int             t_var,		    /* the total number of variables */
                    t_equ;		    /* the total number of equalities */
    IVECTOR         coeff;		    /* the coefficient vector */
{
    int             i, j, flag = 0;

/*    fprintf(output, "\n\nEqualities :\n");  */

    for (i = 1; i <= t_equ; i++)
    {
	flag = 0;
	for (j = 1; j <= t_var + 1; j++)
	{
	    if ((flag == 0) && (equal[i][j] != 0.0))
	    {
		fprintf(output, " %3.2fX%d", equal[i][j], coeff[j]);
		flag = 1;
	    } else if (j == t_var + 1)
		fprintf(output, "  =  %3.2f\n", rhs[i]);
	    else if (equal[i][j] < 0.0)
		fprintf(output, " - %3.2fX%d", fabs(equal[i][j]), coeff[j]);
	    else if (equal[i][j] > 0.0)
		fprintf(output, " + %3.2fX%d", fabs(equal[i][j]), coeff[j]);
	}
    }
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_inequalities()                         */
/*                                                                              */
/*           SYNOPSIS          :   void print_inequalities(equal,t_var,t_equ,   */
/*                                                              coeff,ineq_rhs) */
/*                                                                              */
/*           DESCRIPTION       :   This function prints the matrix passed, on to*/
/*                                  the standard output, in the format of       */
/*                                  inequalities.                               */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
print_inequalities(equal, t_var, t_equ, coeff, ineq_rhs)
    MATRIX          equal;		    /* the inequalities matrix */
    VECTOR          ineq_rhs;		    /* the right hand side of the
					     * inequalities */
    int             t_var,		    /* the total number of variables */
                    t_equ;		    /* the total number of
					     * inequalites */
    IVECTOR         coeff;		    /* the coefficient vector of
					     * ineqaulites */
{
    int             i, j, flag = 0;

    fprintf(output, "\n\nLinear inequalities :\n");

    for (i = 1; i <= t_equ; i++)
    {
	flag = 0;
	for (j = 1; j <= t_var + 1; j++)
	{
	    if ((flag == 0) && (equal[i][j] != 0.0))
	    {
		fprintf(output, " %3.2fX%d", equal[i][j], coeff[j]);
		flag = 1;
	    } else if (j == t_var + 1)
		fprintf(output, " <=  %3.2f\n", ineq_rhs[i]);
	    else if (equal[i][j] < 0.0)
		fprintf(output, " - %3.2fX%d", fabs(equal[i][j]), coeff[j]);
	    else if (equal[i][j] > 0.0)
		fprintf(output, " + %3.2fX%d", fabs(equal[i][j]), coeff[j]);
	}
    }
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_domains()                              */
/*                                                                              */
/*           SYNOPSIS          :   void print_domains(equal,t_equ)              */
/*                                                                              */
/*           DESCRIPTION       :   This function prints the matrix passed, on to*/
/*                                  the standard output, in the format of       */
/*                                  domains.                                    */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
print_domains(equal, t_equ)
    MATRIX          equal;		    /* the domains matrix, with the
					     * upper and lower limits */
    int             t_equ;		    /* the total number of domains */
{
    int             i, j, temp;

    fprintf(output, "\n\nDomains :\n");

    for (i = 1; i <= t_equ; i++)
    {
	for (j = 1; j <= 3; j++)
	{
	    if (j == 2)
		fprintf(output, "  <=  X%-2d  <=   ", (int) equal[i][j]);
	    else
		fprintf(output, " %3.2f ", equal[i][j]);
	}
	fprintf(output, "\n");
    }
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_matrix()                               */
/*                                                                              */
/*           SYNOPSIS          :   void print_matrix(lr,ur,lc,uc,mat)           */
/*                                                                              */
/*           DESCRIPTION       :   This function prints a given float matrix,   */
/*                                  on to the standard output                   */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main(),                                      */
/*                                 optimization().                              */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
print_matrix(lr, ur, lc, uc, mat)
    int             lr, ur, lc, uc;
    MATRIX          mat;
{
    int             i, j;

    for (i = lr; i <= ur; i++)
    {
	fprintf(output, "\n");
	for (j = lc; j <= uc; j++)
	    fprintf(output, "%5.2f\t", mat[i][j]);
    }
    fprintf(output, "\n\n");
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_population()                           */
/*                                                                              */
/*           SYNOPSIS          :   void print_population(lr,ur,lc,uc,mat)       */
/*                                                                              */
/*           DESCRIPTION       :   This function prints the initial and final   */
/*                                  population on to the standard output.       */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   optimization()                               */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*            A             9/15/92      Tom Logan                              */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
print_population(out, r, c, mat)
    FILE           *out;
    int             r, c;
    MATRIX          mat;
{
    int             i, j;

    for (i = 1; i <= r; i++)
    {
	fprintf(out, "%20.8f", mat[i][0]);
	for (j = 1; j <= c - 1; j++)
	{
	    if (((j - 1) % 3 == 0) && (j != 1))
		fprintf(out, "\n                    ");
	    fprintf(out, "%20.8f", mat[i][j]);
	}
	fprintf(out, "\n");
    }
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_vector()                               */
/*                                                                              */
/*           SYNOPSIS          :   void print_vector(arr,l,u)                   */
/*                                                                              */
/*           DESCRIPTION       :   This function prints a given float vector,   */
/*                                  on to the standard output                   */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
print_vector(arr, l, u)
    VECTOR          arr;
    int             l, u;
{
    int             i;

    for (i = l; i <= u; i++)
	fprintf(output, "%18.8f\t", arr[i]);
/*
    for (i = l; i <= u; i++)
	printf("%18.8f\t", arr[i]);
*/
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   print_ivector()                              */
/*                                                                              */
/*           SYNOPSIS          :   void print_ivector(arr,l,u)                  */
/*                                                                              */
/*           DESCRIPTION       :   This function prints a given integer vector, */
/*                                  on to the standard output                   */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   p_equalities()                               */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void 
print_ivector(arr, l, u)
    int             l, u;
    IVECTOR         arr;
{
    int             i;

    for (i = l; i <= u; i++)
	fprintf(output, "%18.8d\t", arr[i]);
    fprintf(output, "\n\n");
}

