
#include "genocop.h"



int 
nonlinear(X, ninumber, nenumber, epsilon)
    VECTOR          X;
    int             ninumber;
    int             nenumber;
    float           epsilon;
{

    int             i, cflag;		    /* constraint flag */
    VECTOR          g;
    VECTOR          h;

    double fQ;
    int iCount;

    if (ninumber >= 1)
    {

	g = vector(1, ninumber);
	for (i = 1; i <= ninumber; i++)
	    g[i] = 0.0;
    }
    if (nenumber >= 1)
    {

	h = vector(1, nenumber);
	for (i = 1; i <= nenumber; i++)
	    h[i] = 0.0;
    }
    cflag = TRUE;			    /* initial state of cflag = TRUE */

    switch (test_num)
    {
    case 1:
                       g[1] = 8 - X[1]*X[1] + X[2]*X[2] - X[3]*X[3] - X[4]*X[4];
                       g[2] = sin(X[2]*X[4]/2.0) + 0.1;
                       g[3] = 2*X[1]*X[2] + X[4];
                       break;

    case 2:
                       fQ = 1.0;
                       for (iCount=1; iCount<21; iCount++)
                         fQ = fQ*X[iCount];

                       g[1] = fQ - 0.75;

                       fQ = 0.0;
                       for (iCount=1; iCount<21; iCount++)
                         fQ = fQ + X[iCount];

                       g[2] = 150.0 - fQ;
                       break;          

    default:
	printf("Non-Linear Constraint Specification error\n");
	exit(0);
    }

    /* Perform check for all of the NI constraints in one pass */
    if (ninumber >= 1)
    {
	for (i = 1; i <= ninumber; i++)
	    if (g[i] < 0.0)
		cflag = FALSE;
	free_vector(g, 1);
    }
    if (nenumber >= 1)
    {
	for (i = 1; i <= nenumber; i++)
	    if ((h[i] < -epsilon) || (h[i] > epsilon))
		cflag = FALSE;
	free_vector(g, 1);
    }
    return (cflag);
}
