#include "genocop.h"

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   evaluate()                                   */
/*                                                                              */
/*           SYNOPSIS          :   float evaluate(X)                            */
/*                                                                              */
/*           DESCRIPTION       :   This function returns the value of the       */
/*                                  function evaluated for the given values of  */
/*                                  the variables.                              */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main(),                                      */
/*                                 optimization().                              */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   8/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/
float 
evaluate(X)
    VECTOR          X;
{
    double          A, d[MAX_VAR], Y[MAX_VAR], sum, res;
    double          a[MAX_VAR][5], c[MAX_VAR], fun, fun1, fun2, pen1, pen2,
                    r1, r2;
    double          b, m1, m2, xr11, xr12, xr21, xr22, q1, q2, q3, q4;
    double          a1, a2, a3, a4, a5, a6;
    int             i, p;


    switch (test_num)
    {
    case 1: return( X[1]*X[1] + X[2]*X[2] + 2*X[3]*X[3] + X[4]*X[4] - 5*X[1]
                - 5*X[2] - 21*X[3] + 7*X[4]);

    case 2: 
/* Keane's problem with 20 variables; see GA Digest, Vol.8, No.16, May 1994 */

                                  q1 = 0.0; q2 = 1.0; q3 = 0.0;
                                for (i=1; i<21; i++)
                                  q1 = q1 + cos(X[i])*cos(X[i])*cos(X[i])*cos(X[i]);

                                for (i=1; i<21; i++)
                                  q2 = q2*cos(X[i])*cos(X[i]);

                                for (i=1; i<21; i++)
                                  q3 = q3 + (double)i*X[i]*X[i];

                                  q4 = (q1 - 2.0*q2)/sqrt(q3);

                                if (q4 < 0) q4 = -q4;
                                return(q4);

    default:
	printf("Invalid test case in eval.c - test case is %f", test_num);
	exit(0);

    }
    return (0);

}
