#include "genocop.h"

#if DOS_SYS
  extern FILE *input,*output;
#endif

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   p_equalities()                               */
/*                                                                              */
/*           SYNOPSIS          :   int p_equalities(equal,t_var,cart,cart_count)*/
/*                                                                              */
/*           DESCRIPTION       :   This function finds the `p` equalities out of*/
/*                                  the total equalites                         */
/*                                                                              */
/*           FUNCTIONS CALLED  :   copy_matrix(),                               */
/*                                 det(),                                       */
/*                                 factorial(),                                 */
/*                                 find_probability(),                          */
/*                                 imatrix(),                                   */
/*                                 ivector(),                                   */
/*                                 matrix,                                      */
/*                                 print_ivector().                             */
/*                                                                              */
/*           CALLING FUNCITONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




int p_equalities(equal,t_var,cart,cart_count,tot_combi)
MATRIX equal;      /*the equalities matrx*/
IVECTOR t_var,     /*array containing the total number of all equalitions*/
        cart;      /*array to contain the variables to be eliminated*/
int cart_count,*tot_combi;
{
  MATRIX p_equal;   /*array to contain the p_equalities*/
  int i,j,k,l,      /*counter variables*/
      p,            /*p variables to be eliminated*/
      tot,          /*total number of variables*/
      t_cart;       /*total possible combinations of p out of tot*/
  IMATRIX cartesian;/*array containing binary representation of all combinations*/
  IVECTOR index;    /*containing the indices of the variables to be eliminated*/
  char status = 'f';/*flag variable*/
  MATRIX det_arr;   /*temporary array, whose determinat is to be found*/
  float d;          /*determinat of a matrix*/

  p  = t_var[1];
  tot = t_var[0];
  t_cart = (int) (factorial(tot)/(factorial(tot - p) * factorial(p)));

  cartesian = imatrix(1,t_cart,1,p);

  find_probability(p,tot,t_cart,cartesian);

  index = ivector(1,p);
  det_arr = matrix(1,p,1,p);
  p_equal = matrix(1,p,1,p);

  l = cart_count;

  while((status == 'f') && (l < t_cart))
    {
      for(i=1; i<=p; i++)
        for(j=1; j<=p; j++)
            p_equal[i][j] = equal[i][cartesian[l][j]];

      l = l + 1;

      copy_matrix(p_equal,det_arr,1,p,1,p);
      d = det(det_arr,p);

      if(d != 0.0)
        {
          status = 't';
          l = l - 1;
          for(i = 1; i<=p; i++)
            cart[i] = cartesian[l][i];
        }
    }
  if(status == 'f')
    {
      fprintf(output,"The equations do not converge\n");
      exit(0);
    }

/*  fprintf(output,"\nThe eliminated variables are \n\n");
  print_ivector(cart,1,p); */
  *tot_combi = t_cart;

  free_imatrix(cartesian,1,t_cart,1);
  free_ivector(index,1);
  free_matrix(det_arr,1,p,1);
  free_matrix(p_equal,1,p,1);

  return(l);
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   bi_deci()                                    */
/*                                                                              */
/*           SYNOPSIS          :   void bi_deci(prob10,prob,t_cart,tot)         */
/*                                                                              */
/*           DESCRIPTION       :   This function forms the matrix with the      */
/*                                  combination of variables to be eliminated   */
/*                                  from the array with binary representation   */
/*                                  of all possible combinations.               */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   find_probability()                           */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/




void bi_deci(prob10,prob,t_cart,tot)
IMATRIX prob10,prob;
int tot,t_cart;
{
  int i,j,k;

  for(i=1; i<=t_cart; i++)
    {
      k = 1;
      for(j=1; j<=tot; j++)
        if(prob10[i][j] == 1)
          prob[i][k++] = j;
    }
}
