/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   main()                                       */
/*                                                                              */
/*           SYNOPSIS          :   void main()                                  */
/*                                                                              */
/*           DESCRIPTION       :   Given a function with linear constraints,    */
/*                                  which is to be optimized, subject to a set  */
/*                                  of Equalities, Inequalities and Domains,    */
/*                                  this program will eliminate all the         */
/*                                  equalities, and hence reduce the total      */
/*                                  number of variables to be dealt with. It    */
/*                                  will then produce a set of equations all of */
/*                                  all of which are domain constraints only.   */
/*                                  An initial population of variables vectors  */
/*                                  is created, satisfying all the constraints. */
/*                                  The process of evaluation, selection and    */
/*                                  recombination is repeated for the total     */
/*                                  number of generations specified by the user.*/
/*                                  The final output is a population of vectors */
/*                                  with various values generated during the    */
/*                                  process of evaluation.                      */
/*                                                                              */
/*           FUNCTIONS CALLED  :    evaluate()                                  */
/*                                  find_ac1_ac2(),                             */
/*                                  find_final_mat1(),                          */
/*                                  find_final_mat2(),                          */
/*                                  find_final_mat3(),                          */
/*                                  find_limits(),                              */
/*                                  find_lu1_lu2(),                             */
/*                                  find_new_in_eq(),                           */
/*                                  find_org_in_eq(),                           */
/*                                  find_x1_x2,                                 */
/*                                  get_var_order(),                            */
/*                                  imatrix(),                                  */
/*                                  initialize(),                               */
/*                                  initialize_x2(),                            */
/*                                  inverse(),                                  */
/*                                  ivector(),                                  */
/*                                  matrix(),                                   */
/*                                  mmprod(),                                   */
/*                                  mvprod(),                                   */
/*                                  optimization(),                             */
/*                                  p_equalities(),                             */
/*                                  print_equalities(),                         */
/*                                  print_inequalities(),                       */
/*                                  print_domains(),                            */
/*                                  read_file(),                                */
/*                                  seed(),                                     */
/*                                  vector(),                                   */
/*                                  write_file().                               */
/*                                                                              */
/*           CALLING FUNCITONS :   None                                         */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/
#include "genocop.h"

#if DOS_SYS
  FILE *input,*output;
  int   test_num;
  long rseed;
  unsigned int rand_array[SHUFFLE];
#endif

void main(argc,argv)
int argc;
char *argv[];
{
  MATRIX equalities,   /*Matrix for equalities*/
         inequalities, /*Matrix for inequalities*/
         domains,      /*Matrix for Domains*/
         a1,           /*Eqalities split into a1 and a2*/
         a2,
         inv_a1,       /*Inverse matrix of a1*/
         c1,           /*Inequalities split into c1 and c2*/
         c2,
         new_in_eq,    /*Inequalities obtained from Equalities*/
         org_ineq,     /*Modified original Inequalities*/
         final_mat,    /*The final Domain*/
         inva1_a2;     /*Product of Inverse of a1 and a2*/

  VECTOR inva1_b,      /*Product of InverseA1 and vector, rhs of equalities*/
         eq_rhs,       /*Right hand side of the equalities*/
         ineq_rhs,     /*Right hand side of the inequalities*/
         ldomain,      /*Lower limits of the domains*/
         udomain,      /*Upper limits of the domains*/
         l1,           /*lower and upper limits corresponding to the variables*/
         l2,                        /*in x1 and x2*/
         u1,
         u2,
         X;            /*Initial values for the variables*/

  IMATRIX var_order;   /*Order of the variables x1 followed by x2*/

  IVECTOR eq_co,       /*Vector X for the Equalities*/
          ineq_co,     /*Vector X for the Inequalities*/
          x1,          /*eq_co divided into x1 and x2*/
          x2,
          cart;        /*Array containing the 'p' variables*/

  FLAG _PROGEND;       /*Flag to check the correctness of input data*/

  INDEX fin,           /*Size of final matrix*/
        newin,         /*Size of new inequalities*/
        a1a2;          /*Size of the product matrix a1_a2*/

  int cart_count = 0,  /*Get a different combination of x2 variables*/
      tot_combi,       /*Total combinations of x2 variables*/
      i,               /*Counter variable*/
      org_col,         /*Final inequalities col - x2_variables + RHS of ineq*/
      tot_var,         /*Total number of variables in the problem*/
      tot_equ,         /*Total number of equalities, also p-equalities*/
      tot_ine,         /*Total number of inequalities*/
      tot_dom,         /*Total number of domains, given in the input file*/
      x2_vari,         /*Remaining variables after p-variables were eliminated*/
      tot_arr[4];      /*Array holding total number of variables, equalities,*/
                       /*inequalites and domains in the same order*/
  time_t start_time,
         stop_time;
  unsigned long delta_time;
  char   time_str[27];

/********************************************************************************/
  if (argc < 3)
    {
      printf("******* Invalid command line syntax *******\n\n");
      printf("Syntax is:genocop <infilename> <outfilename>\n\n");
      exit(1);
    }
#if DOS_SYS
  timezone = 60*60*(EST_OFFSET+5);  /* compute offset form GMT */
#endif
  start_time = time(NULL);
  strcpy(time_str, ctime(&start_time));
  seed();

  input = fopen(argv[1],"r");
  if(input == NULL)
    {
      printf("Open of %s for input failed",argv[1]);
      exit(1);
    }
  output = fopen(argv[2],"w");
    if(output == NULL)
    {
      printf("Open of %s for output failed",argv[2]);
      fclose(input);
      exit(1);
    }

  fprintf(output,"%s",time_str);
  fscanf(input," %d",&tot_arr[0]);/*total variables*/
  fscanf(input," %d",&tot_arr[1]);/*total equalities*/
  fscanf(input," %d",&tot_arr[2]);/*total inequalities*/
  fscanf(input," %d",&tot_arr[3]);/*total domains*/

  fin.r = tot_arr[2]+tot_arr[0];    /*total number of inequalities + domains*/
  fin.c = tot_arr[0]-tot_arr[1]+2;  /*x2 variables + lower limits + upper limits*/
  org_col = tot_arr[0]-tot_arr[1]+1;/*x2 variables + rhs*/
  tot_var = tot_arr[0];             /*total number of variables*/
  if (tot_var > MAX_VAR)
    printf("Too many variables - Increase MAX_VAR in header file");
  tot_equ = tot_arr[1];             /*total number of equalities*/
  tot_ine = tot_arr[2];             /*total number of inequalities*/
  x2_vari = tot_arr[0] - tot_arr[1];/*total variables - p-equalities*/
  newin.r = tot_equ;
  newin.c = fin.c;
  a1a2.r = tot_equ;
  a1a2.c = org_col;

  /*Allocating memory for all the vectors and matrices*/
  final_mat = matrix(1,fin.r,1,fin.c);

  equalities = matrix(1,tot_equ,1,tot_var+1);
  eq_co = ivector(1,tot_var);
  eq_rhs = vector(1,tot_equ);
  a1 = matrix(1,tot_equ,1,tot_equ);
  a2 = matrix(1,tot_equ,1,x2_vari);
  inv_a1 = matrix(1,tot_equ,1,tot_equ);
  inva1_a2 = matrix(1,tot_equ,1,x2_vari);
  inva1_b = vector(1,tot_equ);
  new_in_eq = matrix(1,tot_equ,1,fin.c);

  inequalities = matrix(1,tot_ine,1,tot_var+1);
  ineq_co = ivector(1,tot_var);
  ineq_rhs = vector(1,tot_ine);
  c1 = matrix(1,tot_ine,1,tot_equ);
  c2 = matrix(1,tot_ine,1,x2_vari);
  org_ineq = matrix(1,tot_ine,1,org_col);

  domains = matrix(1,tot_var,1,3);
  ldomain = vector(1,tot_var);
  udomain = vector(1,tot_var);

  l1 = vector(1, tot_equ);
  u1 = vector(1, tot_equ);
  x1 = ivector(1,tot_equ);

  l2 = vector(1, x2_vari);
  u2 = vector(1, x2_vari);
  x2 = ivector(1,x2_vari);

  X = vector(1,tot_var);
  var_order = imatrix(1,tot_var,1,2);
  cart = ivector(1,tot_equ);

  /*Reading the data file*/
  read_file(equalities,inequalities,domains,tot_arr);

  /*Initialization*/
  for(i=1; i<=tot_var; i++)
    {
      eq_co[i] = i;
      ineq_co[i] = i;
    }
  for(i=1; i<=tot_equ; i++)
    eq_rhs[i] = equalities[i][tot_var+1];
   for(i=1; i<=tot_ine; i++)
    ineq_rhs[i] = inequalities[i][tot_var+1];

  print_equalities(equalities,tot_var,tot_equ,eq_co,eq_rhs);
  print_inequalities(inequalities,tot_var,tot_ine,ineq_co,ineq_rhs);
  print_domains(domains,tot_var);

  free_ivector(eq_co,1);
  free_ivector(ineq_co,1);

 /* do
    { */
       if(tot_equ != 0)
        { 
          /*This procedure finds p-equalities that should be eliminated which is 'cart'*/
          /*cart_count =
          p_equalities(equalities,tot_arr,cart,cart_count+1,&tot_combi);*/

          /*From 'cart' the order of variables is got, p-variables followed by the rest*/
          get_var_order(tot_arr,cart,var_order);

          /*The original vector X is divided into x1(p-variables) and x2(the rest)*/
          find_x1_x2(tot_var,var_order,x1,x2);

          /*The original equalities is divided into two matrices a1(p-equalities and a2*/
          find_ac1_ac2(tot_equ,tot_equ,x2_vari,x1,x2,equalities,a1,a2);

          /*This procedure finds the inverse of a1*/
          inverse(a1,inv_a1,tot_equ);

          /*Matrix product of inverse of a1 and a2*/
          mmprod(tot_equ,tot_equ,x2_vari,inva1_a2,inv_a1,a2);

          /*Vector product of inverse of a1 and the RHS of the equalities*/
          mvprod(tot_equ,tot_equ,inva1_b,inv_a1,eq_rhs);

          /*The original inequalities divided into c1 and c2*/
          find_ac1_ac2(tot_equ,tot_ine,x2_vari,x1,x2,inequalities,c1,c2);

          /*split the domain matrix into Llim and Ulim vectors*/
          find_limits(tot_var,domains,ldomain,udomain);

          /*find the Llim and Ulim corresponding to x1 and x2*/
          find_lu1_lu2(tot_arr,x1,x2,ldomain,l1,l2);
          find_lu1_lu2(tot_arr,x1,x2,udomain,u1,u2);

          /*Find the new inequalities from the original equalities*/
          find_new_in_eq(inva1_b,inva1_a2,l1,u1,newin,new_in_eq);

          /*find the new inequalities from the original inequalities*/
          find_org_in_eq(inva1_b,inva1_a2,ineq_rhs,c1,c2,tot_ine,a1a2,org_ineq);

          /*initializing the final output matrix*/
          initialize(final_mat,fin);

          /*append the remaining domains, converted equalities and ineqalites to form the
            final matrix*/
          find_final_mat1(l2,u2,final_mat,x2_vari,fin.c);
          find_final_mat2(new_in_eq,tot_equ,fin.c,org_col,final_mat);
          find_final_mat3(org_ineq,tot_ine,org_col,tot_var+1,final_mat);
        }
      else
        {
          for (i=1; i<=tot_var; i++)
            {
              l2[i] = domains[i][1];
              x2[i] = domains[i][2];
              u2[i] = domains[i][3];
            }
          initialize(final_mat,fin);
          find_final_mat1(l2,u2,final_mat,tot_var,fin.c);

          if(tot_ine != 0)
            find_final_mat3(inequalities,tot_ine,org_col,tot_var+1,final_mat);
        }
      /*This function gets a set of starting points for the variables*/
      /*_PROGEND = initialize_x2(final_mat,fin,x1,x2,tot_equ,X,inva1_b);*/
    /* }while((!_PROGEND)&&(cart_count < tot_combi)); */

  free_vector(eq_rhs,1);
  free_vector(ineq_rhs,1);
  free_vector(ldomain,1);
  free_vector(udomain,1);
  free_vector(l1,1);
  free_vector(l2,1);
  free_vector(u1,1);
  free_vector(u2,1);
  free_ivector(cart,1);

  if(tot_equ != 0)
    {
     /* if(cart_count >= tot_combi)
        {
          fprintf(output,"Incorrect data");
          exit(1);
        } */

/*    write_file(final_mat,fin,inva1_b,x1,x2,tot_equ,x2_vari,tot_var+1); */

      /*This procedure initializes the initial population with the values generated*/
      /*and applies the genetic operators and reproduces a new generation; evaluates*/
      /*each agent of the new generation, and again goes through the cycle of*/
      /*reproduction and evaluation, for the number of times, user has specified*/
      /*and prints out a final population with best agents*/
      optimization(X,x1,x2,final_mat,fin,tot_equ,inva1_b);
    }
  else
    optimization(X,x2,x2,final_mat,fin,tot_equ,inva1_b);
  stop_time = time(NULL);
  delta_time = (unsigned long) stop_time - start_time;
  fprintf(output,"\n\nTotal run time : %lu seconds\n",delta_time);
  fclose(output);

    free_matrix(final_mat ,1,fin.r,1);
    free_matrix(equalities,1,tot_equ,1);
    free_matrix(a1        ,1,tot_equ,1);
    free_matrix(a2        ,1,tot_equ,1);
    free_matrix(inv_a1    ,1,tot_equ,1);
    free_matrix(inva1_a2  ,1,tot_equ,1);
    free_vector(inva1_b   ,1);
    free_matrix(new_in_eq ,1,tot_equ,1);
    free_matrix(inequalities,1,tot_ine,1);
    free_matrix(c1        ,1,tot_ine,1);
    free_matrix(c2        ,1,tot_ine,1);
    free_matrix(org_ineq  ,1,tot_ine,1);
    free_matrix(domains   ,1,tot_var,1);
    free_ivector(x1       ,1);
    free_ivector(x2       ,1);
    free_vector(X         ,1);
    free_imatrix(var_order,1,tot_var,1);

  exit(0);
}



