#include "genocop.h"

#if DOS_SYS
  extern long rseed;
  extern unsigned int rand_array[];
#endif


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   frange_ran()                                 */
/*                                                                              */
/*           SYNOPSIS          :   float frange_ran(llim,ulim)                  */
/*                                                                              */
/*           DESCRIPTION       :   This function returns a random float number  */
/*                                  between the llim and ulim.                  */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCTIONS :   find_live_die(),                             */
/*                                 get_F(),                                     */
/*                                 initialize_x2(),                             */
/*                                 oper1().                                     */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   2/23/93                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/


float frange_ran(llim,ulim)
float ulim,llim;   /*The upper and lower limits between which the random*/
                   /*number is to be generated*/

{
  float diff,num1;


  diff = ulim - llim;
  if (diff == 0)
    return(llim);
  else if(diff < 0.0001)
    return((flip() == TAIL) ? llim : ulim);
  do
    num1 = llim + (float) ( (newrand()*(ulim-llim))/65535) ;
  while((num1<llim)||(num1>ulim));
  return(num1);
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   initialize_x2()                              */
/*                                                                              */
/*           SYNOPSIS          :   FLAG initialize_x2(final,rc,x1,x2,x1_vari,   */
/*                                                                      x2_vari)*/
/*                                                                              */
/*           DESCRIPTION       :   This function generates random values for    */
/*                                  each of the x2 variables, in such a way that*/
/*                                  none of the constriants are violated; if no */
/*                                  such values could be found after a          */
/*                                  predetermined number of times, it returns   */
/*                                  FALSE.                                      */
/*                                                                              */
/*           FUNCTIONS CALLED  :   frange_ran(),                                */
/*                                 ivector(),                                   */
/*                                 matrix(),                                    */
/*                                 vector().                                    */
/*                                                                              */
/*           CALLING FUNCTIONS :   main()                                       */
/*                                                                              */
/*           AUTHOR            :   Swarnalatha Swaminathan                      */
/*                                                                              */
/*           DATE              :   1/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/


FLAG initialize_x2(final,rc,x1,x2,x1_vari,X,a1_b)
MATRIX final;        /*The final matrix*/
VECTOR X,a1_b;       /*Vector to hold the values of all the variables to be generated*/
IVECTOR x1,x2;       /*The p-variables eliminated and the remaining variables*/
INDEX rc;            /*Row and column of the final matrix*/
int x1_vari;         /*Number of variables eliminated*/
{
  int i,j,           /*counter variables*/
      x2_vari=rc.c-2,/*Total number of existing variables*/
      try=0;         /*Number of tries before getting a value for a variable*/
  FLAG _LOW,         /*Flags to check if the lower bounds are satisfied*/
       _HIGH;        /*Flags to check if the pper bounds are satisfied*/
  VECTOR temp;       /*Temporary vector to hold the random values of the variables*/
  MATRIX trymat;     /*Total after substitution of the generated variable value*/
  double sum = 0.0;
  FLAG _CHECK = TRUE;
  FLAG LOCAL_CHECK = TRUE;


  temp = vector(1,x2_vari);
  trymat = matrix(1,rc.r-x2_vari,0,x2_vari);
  LOCAL_CHECK=TRUE; _CHECK=TRUE;

  do
    {
      if(try < TRIES)
        /*Increment the number of tries*/
        ++try;
      for(i=1; i<=x2_vari; i++)
        /*For each constraints, generate a value for a variable between the bounds*/
        temp[i] = frange_ran(final[i][1],final[i][rc.c]);

      if(x2_vari != rc.r)
        {
          for(j=x2_vari+1; j<=rc.r; j++)
            {
              sum = 0;
              for(i=1; i<=x2_vari; i++)
                /*Evaluate the equation after a value is generated for a variable*/
                sum  =  sum + temp[i] * final[j][i+1];

              /*Check if the lower and upper bounds are satisfied*/
              _LOW = (sum >= final[j][1]) ? TRUE : FALSE;
              _HIGH = (sum <= final[j][rc.c]) ? TRUE : FALSE;

              if((!_LOW)||(!_HIGH))
                break;
            }
        }
      else
        _LOW = _HIGH = TRUE;
    }while((try<TRIES) && ((!_LOW)||(!_HIGH)));
    
    
  if(try >= TRIES)
    {
      _CHECK=FALSE;
      printf("No feasible random solution found after %d tries\n", TRIES);

      do {
           LOCAL_CHECK=TRUE;
      printf("Please input initial values\n");
      for(i=1; i<=x1_vari+x2_vari; i++)
        {
          printf("\nX%d\t",i);
          scanf("%f",&X[i]);
        }

      for(j=1; j<=rc.r; j++)
        {
          sum = 0.0;
          for(i=1; i<=x2_vari; i++)
            /*Evaluate the equation after a value is generated for a variable*/
            sum  =  sum + X[x2[i]] * final[j][i+1];

          /*Check if the lower and upper bounds are satisfied*/
          _LOW = (sum >= final[j][1]) ? TRUE : FALSE;
          _HIGH = (sum <= final[j][rc.c]) ? TRUE : FALSE;
			
          if((!_LOW)||(!_HIGH))
          {
              printf("The input values do not satisfy the constraint #%d\n", j);
              LOCAL_CHECK=FALSE;
          }
        }
      } while (LOCAL_CHECK==FALSE); /* end of do...while LOCAL_CHECK */
    } /* end of if try > TRIES .........................*/
    
    else
    {
      if(x1_vari != 0)
        {
          for(i=1; i<=x2_vari; i++)
            X[x2[i]] = temp[i];

          for(j=1; j<=x1_vari; j++)
            {
              X[x1[j]] = a1_b[j];
              for(i=1; i<=x2_vari; i++)
                X[x1[j]] = X[x1[j]] + temp[i] * final[j+x2_vari][i+1];
            }
        }
      else
        for(i=1; i<=x2_vari; i++)
            X[i] = temp[i];

    }
  free_vector(temp,1);
  free_matrix(trymat,1,rc.r-x2_vari,0);

  return (_CHECK);
}

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   seed()                                       */
/*                                                                              */
/*           SYNOPSIS          :   void seed()                                  */
/*                                                                              */
/*           DESCRIPTION       :   This function generates the seed for         */
/*                                  generating the random numbers and           */
/*                                  warms up the generator.                     */
/*                                                                              */
/*           FUNCTIONS CALLED  :   randint(),                                   */
/*                                 newrand()                                    */
/*                                                                              */
/*           CALLING FUNCTIONS :   main(),                                      */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   2/28/93                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/


void seed()
{
  long         l_time;
  int          n;
  unsigned int x;

  l_time = time(NULL);
  l_time = l_time % 65536;
  rseed = l_time;

  for (n=0;n<SHUFFLE;n++)                  /* initialize random number array */
    rand_array[n] = randint();
  for (n=0;n<1000;n++)                     /* warm up the generator */
    x = newrand();
}


/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   randint()                                    */
/*                                                                              */
/*           SYNOPSIS          :   unsigned int randint()                       */
/*                                                                              */
/*           DESCRIPTION       :   This function generates returns a random     */
/*                                  number (unsigned int). newrand() should     */
/*                                  be used as the actual random number         */
/*                                  genertor. This function is called by        */
/*                                  newrand().                                  */
/*                                                                              */
/*           FUNCTIONS CALLED  :   none                                         */
/*                                                                              */
/*           CALLING FUNCTIONS :   newrand(),                                   */
/*                                 seed()                                       */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   2/28/93                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/
unsigned int randint()
{
  int num;

   rseed = (MULT * rseed + INCR) % MOD;
   num = rseed%65536;
   return(num);
}



/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   newrand()                                    */
/*                                                                              */
/*           SYNOPSIS          :   unsigned int newrand()                       */
/*                                                                              */
/*           DESCRIPTION       :   This function generates returns a random     */
/*                                  number (unsigned int).                      */
/*                                                                              */
/*           FUNCTIONS CALLED  :   randint()                                    */
/*                                                                              */
/*           CALLING FUNCTIONS :   seed(),                                      */
/*                                 flip() in genocop.h,                         */
/*                                 irange_ran                                   */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   2/28/93                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/
unsigned int newrand()
{
  int r_offset;
  unsigned int ran_int;

  r_offset = (int) (randint() % SHUFFLE);
  ran_int = rand_array[r_offset];
  rand_array[r_offset] = randint();
  return(ran_int);
}
