#include "genocop.h"

/********************************************************************************/
/*                                                                              */
/*           FUNCTION NAME     :   evaluate()                                   */
/*                                                                              */
/*           SYNOPSIS          :   float evaluate(X)                            */
/*                                                                              */
/*           DESCRIPTION       :   This function returns the value of the       */
/*                                  function evaluated for the given values of  */
/*                                  the variables.                              */
/*                                                                              */
/*           FUNCTIONS CALLED  :   None                                         */
/*                                                                              */
/*           CALLING FUNCITONS :   main(),                                      */
/*                                 optimization().                              */
/*                                                                              */
/*           AUTHOR            :   Tom Logan                                    */
/*                                                                              */
/*           DATE              :   8/17/92                                      */
/*                                                                              */
/*                                                                              */
/*           REV            DATE            BY           DESCRIPTION            */
/*           ---            ----            --           -----------            */
/*                                                                              */
/*                                                                              */
/********************************************************************************/
float evaluate(X)
VECTOR X;
{
  double   A, d[MAX_VAR], Y[MAX_VAR], sum, res;
  double  a[MAX_VAR][5], c[MAX_VAR], fun, fun1, fun2, pen1, pen2, r1, r2;
  double  b, m1, m2, xr11, xr12, xr21, xr22, q1, q2, q3, q4;
  double a1, a2, a3, a4, a5, a6;
  int     i, p;


  switch (test_num)
   {
     case 1:  return(X[1]*X[2]);
     case 2:  return(X[1]*(70.0-4.0*X[1]) + X[2]*(150.0 - 15.0*X[2])
                     - 100.0 - 15.0*X[1] - 15.0*X[2]);
     case 3:  return(-1.0*(X[1]-3.0)*(X[1]-3.0) - (X[2]-2.0)*(X[2]-2.0));
     case 4:  return(-2.0*X[1]*X[1] - X[2]*X[2] + X[1]*X[2] + 8.0*X[1] + 3.0*X[2]);
     case 5:  return((X[1] + 10.0*X[2])*(X[1] + 10.0*X[2]) + 
              5.0*(X[3] - X[4])*(X[3] - X[4]) + (X[2] - 2.0*X[3])*(X[2] - 
              2.0*X[3])*(X[2] - 2.0*X[3])*(X[2] - 2.0*X[3]) + 10.0*(X[1] - 
              X[4])*(X[1] - X[4])*(X[1] - X[4])*(X[1] - X[4]));
     case 6:  return(0.2*X[1]*X[1] + 0.08*X[2]*X[2] + 0.18*X[3]*X[3] + 
              0.1*X[1]*X[2] + 0.04*X[1]*X[3] + 0.06*X[3]*X[2]);
     case 7:  return(X[1]*X[1]/2.0 + X[2]*X[2] - X[1]*X[2] - X[1] - X[2]);
     case 8:  return(-2.0*X[1]*X[1] -2.0*X[2]*X[2] + 2.0*X[1]*X[2] + 4.0*X[1] + 6.0*X[2]);
     case 9:  return(X[1]*X[2]*X[3]*X[4]*X[5]);
     case 10: return((X[1] - 1.0)*(X[1] - 1.0) +
               (X[1] - X[2]*X[2])*(X[1] - X[2]*X[2]) + (X[2] - 1.0)*(X[2] - 1.0) +
               (X[1] - X[3]*X[3])*(X[1] - X[3]*X[3]) + (X[3] - 1.0)*(X[3] - 1.0) +
               (X[1] - X[4]*X[4])*(X[1] - X[4]*X[4]) + (X[4] - 1.0)*(X[4] - 1.0) +
               (X[1] - X[5]*X[5])*(X[1] - X[5]*X[5]) + (X[5] - 1.0)*(X[5] - 1.0));
     case 11: c[1] = 0.0;    c[2] = 21.0;  c[3] = 50.0; c[4] = 62.0;
              c[5] = 21.0;   c[6] = 0.0;   c[7] = 17.0; c[8] = 54.0;
              c[9] = 50.0;   c[10] = 17.0; c[11] = 0.0; c[12] = 60.0;
              sum = 0.0;
              for (p=1; p<13; ++p) {
                         if (X[p] > 0.001)
                        {sum = sum + 5.0 + c[p]*sqrt(X[p]);}}
              return(sum);
     case 12: return(X[1] + X[2] + X[3] + X[4] + X[5] + X[6] + X[7] + X[8]);
     case 13: return(X[1]*X[2] + X[3] + X[4]*X[5]);
     case 14: return(X[1]*X[2] + X[3] + X[4]*(10.0 - X[1] - X[2] - X[3] - X[4]));
     case 15: c[1] = 0.0;    c[2] = 21.0;  c[3] = 50.0; c[4] = 62.0;
              c[5] = 21.0;   c[6] = 0.0;   c[7] = 17.0; c[8] = 54.0;
              c[9] = 50.0;   c[10] = 17.0; c[11] = 0.0; c[12] = 60.0;

              sum = 0.0;
              if (X[1] > 0.001) sum = sum + 5.0 + c[1]*sqrt(X[1]);
              if (X[2] > 0.001) sum = sum + 5.0 + c[2]*sqrt(X[2]);
              if (X[3] > 0.001) sum = sum + 5.0 + c[3]*sqrt(X[3]);
              Y[4] = 10.0 - X[1] - X[2] - X[3];
              if (Y[4] > 0.001) sum = sum + 5.0 + c[4]*sqrt(Y[4]);
              if (X[4] > 0.001) sum = sum + 5.0 + c[5]*sqrt(X[4]);
              if (X[5] > 0.001) sum = sum + 5.0 + c[6]*sqrt(X[5]);
              if (X[6] > 0.001) sum = sum + 5.0 + c[7]*sqrt(X[6]);
              Y[7] = 15.0 - X[4] - X[5] - X[6];
              if (Y[7] > 0.001) sum = sum +
                   5.0 + c[8]*sqrt(15.0 - X[4] - X[5] - X[6]);
              if (3.0 - X[1] - X[4] > 0.001) sum = sum + 5.0 +
                   c[9]*sqrt(3.0 - X[1] - X[4]);
              if (20.0 - X[2] - X[5] > 0.001) sum = sum + 5.0 +
                   c[10]*sqrt(20.0 - X[2] - X[5]);
              if (5.0 - X[3] - X[6] > 0.001) sum = sum + 5.0 +
                   c[11]*sqrt(5.0 - X[3] - X[6]);
              if (X[1] +X[2] +X[3] + X[4] + X[5] +X[6] -8.0 > 0.001) sum = sum +
                   5.0 + c[12]*sqrt(X[1] +X[2] +X[3] +X[4] + X[5] +X[6] -8.0);
              return(sum);
     case 16: return( 100*(X[2]-(X[1]*X[1]))*(X[2]-(X[1]*X[1]))+
                      (1-X[1])*(1-X[1])+
                      90*(X[4]-(X[3]*X[3]))*(X[4]-(X[3]*X[3]))+
                      (1-X[3])*(1-X[3])+
                      10.1*((X[2]-1)*(X[2]-1)  + (X[4]-1)*(X[4]-1)) +
                      19.8*(X[2]-1)*(X[4]-1) );
     case 17: c[1] = -6.089;
              c[2] = -17.164;
              c[3] = -34.054;
              c[4] = -5.914;
              c[5] = -24.721;
              c[6] = -14.986;
              c[7] = -24.100;
              c[8] = -10.708;
              c[9] = -26.662;
              c[10] = -22.179;
              res = 0.0; sum = 0.0;
              for (i=1; i<11; ++i) sum = sum + X[i];
              for (i=1; i<11; ++i)
              res = res + X[i]*(c[i] + log(X[i]/sum));
              return(res);
     case 18: return((3.0*X[1] + X[2] - 2.0*X[3] + 0.8)/(2.0*X[1] - X[2] + X[3]) +
             (4.0*X[1] - 2.0*X[2] + X[3])/(7.0*X[1] + 3.0*X[2] - X[3]));
     case 19: return((-1.0*X[1] + 2.0*X[2] + 2.0)/(3.0*X[1] - 4.0*X[2] + 5.0) +
             (4.0*X[1] - 3.0*X[2] + 4.0)/(-2.0*X[1] + X[2] + 3.0));
     case 20: A = 5.0;
              return(-1.0*A*sin(X[1])*sin(X[2])*sin(X[3])*sin(X[4])*sin(X[5]) -
              sin(5.0*X[1])*sin(5.0*X[2])*sin(5.0*X[3])*sin(5.0*X[4])*sin(5.0*X[5]));
     case 21: return(42.0*X[1] + 44.0*X[2] + 45.0*X[3] + 47.0*X[4] + 47.5*X[5] -
              50.0*X[1]*X[1] - 50.0*X[2]*X[2] - 50.0*X[3]*X[3] -
              50.0*X[4]*X[4] - 50.0*X[5]*X[5]);
     case 22: return(-10.5*X[1] -7.5*X[2] -3.5*X[3] -2.5*X[4] -1.5*X[5] -
              0.5*X[1]*X[1] - 0.5*X[2]*X[2] - 0.5*X[3]*X[3] -
              0.5*X[4]*X[4] - 0.5*X[5]*X[5] -10.0*X[6]);
     case 23: return(5.0*(X[1]+X[2]+X[3]+X[4]-X[1]*X[1]-X[2]*X[2]-X[3]*X[3]-X[4]*X[4]) -
              X[5] - X[6] - X[7] - X[8] - X[9] - X[10] - X[11] - X[12] - X[13]);
     case 24: return(6.5*X[1] - 0.5*X[1]*X[1] - X[2]-2.0*X[3]-3.0*X[4]-2.0*X[5]-X[6]);
     case 25: return(4*X[1] + 3*X[2]);
     case 26: return(X[1]*sin(X[2]) + X[3]*X[3] -12.7*X[4]);
     case 27:  return(
(0.000000-X[1])*(0.000000-X[1])
+
(0.016318-X[2])*(0.016318-X[2])
+
(0.053488-X[3])*(0.053488-X[3])
+
(0.110713-X[4])*(0.110713-X[4])
+
(0.180601-X[5])*(0.180601-X[5])
+
(0.253646-X[6])*(0.253646-X[6])
+
(0.337962-X[7])*(0.337962-X[7])
+
(0.429040-X[8])*(0.429040-X[8])
+
(0.520801-X[9])*(0.520801-X[9])
+
(0.625106-X[10])*(0.625106-X[10])
+
(0.739061-X[11])*(0.739061-X[11])
+
(0.858038-X[12])*(0.858038-X[12])
+
(1.000000-X[13])*(1.000000-X[13])
);
 case 29: return(3.0*(1.0-exp(-1.2*X[1])-1.2*X[1]*exp(-1.2*X[1])) +
                 4.0*(1.0-exp(-1.5*X[2])-1.5*X[2]*exp(-1.5*X[2])) +
                 1.0-exp(-X[1]*X[2]) -X[1] - X[2]);

 case 30: return(X[1]*X[1] + X[2]*X[2] + X[3]*X[3] + X[4]*X[4] + X[5]*X[5] + X[6]*X[6] + 
                 X[7]*X[7] + X[8]*X[8] + X[9]*X[9] + X[10]*X[10] + X[11]*X[11] + X[12]*X[12]
                 + X[13]*X[13]);


 case 31: return(X[1]*X[1] + X[2]*X[2] + X[3]*X[3] + X[4]*X[4] + X[5]*X[5] + X[6]*X[6] + 
                 X[7]*X[7] + X[8]*X[8] + X[9]*X[9] + X[10]*X[10] + X[11]*X[11] + X[12]*X[12] +
 (130 - X[1] - X[2] - X[3] - X[4] - X[5] - X[6] - X[7] - X[8] - X[9] - X[10] - X[11] - X[12])*(130 - X[1] - X[2] - X[3] - X[4] - X[5] - X[6] - X[7] - X[8] - X[9] - X[10] - X[11] - X[12]));

 case 32: return(X[1]);
 case 33: return(X[1]*(X[2]+X[3])/(X[4]+7.0));

 case 34: 

     r1 = 10.0;
     r2 = 10.0;

     pen1 = X[1]*X[1] - X[2] + 1.0;
     pen2 = X[1] - (X[2] - 4.0)*(X[2] - 4.0) - 1.0;

     fun1 = sin(X[1]*X[1]*X[1])*sin(X[2]);
     fun2 = X[1]*X[1]*X[1]*(X[1]+X[2]);
     fun = fun1/fun2;
  
     return(fun - r1*pen1*pen1 - r2*pen2*pen2);

 case 41: return(100.0*(X[2] - X[1]*X[1])*(X[2] - X[1]*X[1]) + (1.0-X[1])*(1.0-X[1]));
 case 42: return(100.0*(X[2] - X[1]*X[1])*(X[2] - X[1]*X[1]) + (1.0-X[1])*(1.0-X[1])
               + 100.0*(X[3] - X[2]*X[2])*(X[3] - X[2]*X[2]) + (1.0-X[2])*(1.0-X[2])
               + 100.0*(X[4] - X[3]*X[3])*(X[4] - X[3]*X[3]) + (1.0-X[3])*(1.0-X[3]));
 case 43: return(100.0*(X[2] - X[1]*X[1])*(X[2] - X[1]*X[1]) + (1.0-X[1])*(1.0-X[1])
               + 100.0*(X[3] - X[2]*X[2])*(X[3] - X[2]*X[2]) + (1.0-X[2])*(1.0-X[2])
               + 100.0*(X[4] - X[3]*X[3])*(X[4] - X[3]*X[3]) + (1.0-X[3])*(1.0-X[3])
               + 100.0*(X[5] - X[4]*X[4])*(X[5] - X[4]*X[4]) + (1.0-X[4])*(1.0-X[4])
               + 100.0*(X[6] - X[5]*X[5])*(X[6] - X[5]*X[5]) + (1.0-X[5])*(1.0-X[5]));
 case 44: return(100.0*(X[2] - X[1]*X[1])*(X[2] - X[1]*X[1]) + (1.0-X[1])*(1.0-X[1])
               + 100.0*(X[3] - X[2]*X[2])*(X[3] - X[2]*X[2]) + (1.0-X[2])*(1.0-X[2])
               + 100.0*(X[4] - X[3]*X[3])*(X[4] - X[3]*X[3]) + (1.0-X[3])*(1.0-X[3])
               + 100.0*(X[5] - X[4]*X[4])*(X[5] - X[4]*X[4]) + (1.0-X[4])*(1.0-X[4])
               + 100.0*(X[6] - X[5]*X[5])*(X[6] - X[5]*X[5]) + (1.0-X[5])*(1.0-X[5])
               + 100.0*(X[7] - X[6]*X[6])*(X[7] - X[6]*X[6]) + (1.0-X[6])*(1.0-X[6])
               + 100.0*(X[8] - X[7]*X[7])*(X[8] - X[7]*X[7]) + (1.0-X[7])*(1.0-X[7]));
 case 51: return( (1.0 + (X[2] + X[1] + 1.0)*(X[2] + X[1] + 1.0)*
                       (19.0 - 14*X[1] +3*X[1]*X[1] - 14*X[2] + 6*X[1]*X[2] + 3*X[2]*X[2]))
                      * (30.0 + (2*X[1] - 3*X[2])*(2*X[1] - 3*X[2])*
                   (18.0 - 32*X[1] +12*X[1]*X[1] + 48*X[2] - 36*X[1]*X[2] + 27*X[2]*X[2])));

 case 52: sum = 0.0; 

          a[1][1] = 4.0;
          a[1][2] = 4.0;
          a[1][3] = 4.0;
          a[1][4] = 4.0;
          a[2][1] = 1.0;
          a[2][2] = 1.0;
          a[2][3] = 1.0;
          a[2][4] = 1.0;
          a[3][1] = 8.0;
          a[3][2] = 8.0;
          a[3][3] = 8.0;
          a[3][4] = 8.0;
          a[4][1] = 6.0;
          a[4][2] = 6.0;
          a[4][3] = 6.0;
          a[4][4] = 6.0;
          a[5][1] = 3.0;
          a[5][2] = 7.0;
          a[5][3] = 3.0;
          a[5][4] = 7.0;

          c[1] = 0.1;
          c[2] = 0.2;
          c[3] = 0.3;
          c[4] = 0.4;
          c[5] = 0.6;

          for (i=1; i<6; ++i)
              sum = sum - 1/((X[1] - a[i][1])*(X[1] - a[i][1])
                            +(X[2] - a[i][2])*(X[2] - a[i][2])
                            +(X[3] - a[i][3])*(X[3] - a[i][3])
                            +(X[4] - a[i][4])*(X[4] - a[i][4]) + c[i]);
              return(sum);
          
 case 53: sum = 0.0; 

          a[1][1] = 4.0;
          a[1][2] = 4.0;
          a[1][3] = 4.0;
          a[1][4] = 4.0;
          a[2][1] = 1.0;
          a[2][2] = 1.0;
          a[2][3] = 1.0;
          a[2][4] = 1.0;
          a[3][1] = 8.0;
          a[3][2] = 8.0;
          a[3][3] = 8.0;
          a[3][4] = 8.0;
          a[4][1] = 6.0;
          a[4][2] = 6.0;
          a[4][3] = 6.0;
          a[4][4] = 6.0;
          a[5][1] = 3.0;
          a[5][2] = 7.0;
          a[5][3] = 3.0;
          a[5][4] = 7.0;
          a[6][1] = 2.0;
          a[6][2] = 9.0;
          a[6][3] = 2.0;
          a[6][4] = 9.0;
          a[7][1] = 5.0;
          a[7][2] = 5.0;
          a[7][3] = 3.0;
          a[7][4] = 3.0;

          c[1] = 0.1;
          c[2] = 0.2;
          c[3] = 0.3;
          c[4] = 0.4;
          c[5] = 0.6;
          c[6] = 0.6;
          c[7] = 0.3;

          for (i=1; i<8; ++i)
              sum = sum - 1/((X[1] - a[i][1])*(X[1] - a[i][1])
                            +(X[2] - a[i][2])*(X[2] - a[i][2])
                            +(X[3] - a[i][3])*(X[3] - a[i][3])
                            +(X[4] - a[i][4])*(X[4] - a[i][4]) + c[i]);
              return(sum);
          
 case 54: sum = 0.0; 

          a[1][1] = 4.0;
          a[1][2] = 4.0;
          a[1][3] = 4.0;
          a[1][4] = 4.0;
          a[2][1] = 1.0;
          a[2][2] = 1.0;
          a[2][3] = 1.0;
          a[2][4] = 1.0;
          a[3][1] = 8.0;
          a[3][2] = 8.0;
          a[3][3] = 8.0;
          a[3][4] = 8.0;
          a[4][1] = 6.0;
          a[4][2] = 6.0;
          a[4][3] = 6.0;
          a[4][4] = 6.0;
          a[5][1] = 3.0;
          a[5][2] = 7.0;
          a[5][3] = 3.0;
          a[5][4] = 7.0;
          a[6][1] = 2.0;
          a[6][2] = 9.0;
          a[6][3] = 2.0;
          a[6][4] = 9.0;
          a[7][1] = 5.0;
          a[7][2] = 5.0;
          a[7][3] = 3.0;
          a[7][4] = 3.0;
          a[8][1] = 8.0;
          a[8][2] = 1.0;
          a[8][3] = 8.0;
          a[8][4] = 1.0;
          a[9][1] = 6.0;
          a[9][2] = 2.0;
          a[9][3] = 6.0;
          a[9][4] = 2.0;
          a[10][1] = 7.0;
          a[10][2] = 3.6;
          a[10][3] = 7.0;
          a[10][4] = 3.6;

          c[1] = 0.1;
          c[2] = 0.2;
          c[3] = 0.3;
          c[4] = 0.4;
          c[5] = 0.6;
          c[6] = 0.6;
          c[7] = 0.3;
          c[8] = 0.7;
          c[9] = 0.5;
          c[10] = 0.5;

          for (i=1; i<11; ++i)
              sum = sum - 1/((X[1] - a[i][1])*(X[1] - a[i][1])
                            +(X[2] - a[i][2])*(X[2] - a[i][2])
                            +(X[3] - a[i][3])*(X[3] - a[i][3])
                            +(X[4] - a[i][4])*(X[4] - a[i][4]) + c[i]);
              return(sum);
          

 case 55: return((4.0 - 2.1*X[1]*X[1] + X[1]*X[1]*X[1]*X[1]/3)*X[1]*X[1] +
                  X[1]*X[2] + (-4.0 + 4*X[2]*X[2])*X[2]*X[2]);

 case 56: fun1 = 0.0;
          for (i=1; i<6; ++i)
              fun1 = fun1 + (float)(i)*cos((i+1.0)*X[1] + (float)(i));
          fun2 = 0.0;
          for (i=1; i<6; ++i)
              fun2 = fun2 + (float)(i)*cos((i+1.0)*X[2] + (float)(i));

          return(fun1*fun2);

 case 57:   b = 3.5;     /* random [0,10]    */
            m1 = 35.5;   /* random [0,100]    */
            m2 = 60.5;   /* random [0,100]    */
            xr11 = 1.5;  /* random [0,b]    */
            xr12 = 7.5;  /* random [b,10]    */            
            xr21 = 4.5;  /* random [0,10]    */
            xr22 = 6.5;  /* random [0,10]    */

            q1 = X[1] - xr11; if (q1 < 0) q1 = q1*(-1.0);
            q2 = X[2] - xr21; if (q2 < 0) q2 = q2*(-1.0);
            q3 = X[1] - xr12; if (q3 < 0) q3 = q3*(-1.0);
            q4 = X[2] - xr22; if (q4 < 0) q4 = q4*(-1.0);
            c[1] = floor(q1) + floor(q2);
            c[2] = floor(q3) + floor(q4);
            if (-0.1 <= c[1] && c[1] <= 0.1) fun1 = m1; else 
                                             fun1 = floor((floor(m1)+0.5)*sin(c[1])/c[1]);
            if (-0.1 <= c[2] && c[2] <= 0.1) fun2 = m2; else
                                             fun2 = floor((floor(m2)+0.5)*sin(c[2])/c[2]);
            if (0.0 <= X[1] && X[1] <= b) return(fun1); else return(fun2);

 case 58: return(-1.0*cos(X[1])*cos(X[2])*exp(-1.0*(X[1] - 3.14159)*(X[1] - 3.14159) 
                                        - (X[2] - 3.14159)*(X[2] - 3.14159)));

 case 59: a1 = 1.0;
          a2 = 5.1/(4*3.14159*3.14159);
          a3 = 5/3.14159;
          a4 = 6.0;
          a5 = 10.0;
          a6 = 1/(8*3.14159);

          return(a1*(X[2] - a2*X[1]*X[1] + a3*X[1] - a4)*(X[2] - a2*X[1]*X[1] + a3*X[1] - a4)
                 + a5*(1.0 - a6)*cos(X[1]) + a5);


 case 60:  return(X[1]+X[2]+X[3]+X[4]+X[5]+X[6]+X[7]+X[8]+X[9]+X[10]+X[11]+X[12]+X[13]+X[14]+X[15]+X[16]+X[17]+X[18]);

 case 70: return(6.0*X[1]+4.0*X[2]+2.0*X[3]+5.0*X[4]+3.0*X[5]+X[6]); 

 case 81: return(X[1]*X[1] + X[2]*X[2] + X[3]*X[3] + X[4]*X[4] + X[5]*X[5]);

 case 82: return(X[1]*X[1] - X[1]*X[2] + X[3]);

     default: printf("Invalid test case in eval.c - test case is %f", test_num);
              exit(0);

   }
  return(0);

}





