'________________________________________________________________________________________________________________
'
' DOOMKILL.VBS - myDoom Virus Cleaning Script (v1.1)
' 1/28/04
' rpuckett@cisco.com
'
'
' You have a royalty-free right to use, modify, reproduce and distribute this code (and/or any 
' modified version) in any way you find useful, with the agreement that Cisco Systems 
' provides no warranty, obligations or liability for this code. If you reuse or modify this 
' code, please retain this copyright notice.
'
' Copyright (C) 2004
'
'________________________________________________________________________________________________________________
'

option explicit
on error resume next

' constants
const ForReading         = 1
const ForAppending       = 8 
const HKEY_LOCAL_MACHINE = &H80000002
const HKEY_CLASSES_ROOT  = &H80000000

dim objTextFile, wmiconn, wmireg, userpw, srvlst, userid, retval, lRet, strRegVal, webChk, strClsKey, webDLL, rbtcmd
dim objPids, oPid, objAnt, oAnt, objFSO, badDLL, badEXE, sysDir, objOS, objLOG, olog, strLog, a, b, c, d, i
dim objPing, ping(), infected, icount(), strhost, strQuery, oOS, reboot, strRunKey, strRunVal, y, strHosts() 

set objFSO   = CreateObject("Scripting.FileSystemObject")
set objLOG   = CreateObject("Scripting.FileSystemObject")
Set objPing  = wscript.CreateObject("WScript.Shell") 

' log variables
strLog    = "c:\doomkill-" & _
			monthname(month(now), true) & "_" & _
			day(now) & "_" & _
			year(now) & "-" & _
			hour(now) & "-" & _
			minute(now) & "-" & _
			second(now) & ".log"

badDLL    = "shimgapi.dll"
badEXE    = "taskmon.exe"
webDLL    = "webcheck.dll"
webChk    = "%systemroot%\system32\webcheck.dll"
strClsKey = "CLSID\{E6FB5E20-DE35-11CF-9C87-00AA005127ED}\InProcServer32"
strRunKey = "SOFTWARE\Microsoft\Windows\CurrentVersion\Run"
strRunVal = "TaskMon"

' counter variables
a         = 0
b         = 0
c         = 0
y         = 0
reboot    = 0 

' parse CLI options
call parse_cli

set oLog  = objLOG.CreateTextFile(strLog, ForAppending, TRUE)

'________________________________________________________________________________________________________________
'
call log_it("script started at: " & now & VbCrLf)
'________________________________________________________________________________________________________________
'

call log_it("CLI PARAMETERS:" & VbCrLf)
call log_it(" - logon id (if present): " & userid)
call log_it(" - server list: " & srvlst)
call log_it(" - log file: " & strLog)
if reboot = 0 then 
	rbtcmd = "NO"
else 
	rbtcmd = "YES"
end if 
call log_it(" - reboot: " & rbtcmd)
		
' retrieve server list		 
if objFSO.FileExists(srvlst) then
	set objTextFile = objFSO.OpenTextFile(srvlst, ForReading)
else
	call log_it("the specified server file (" & srvlst & _
				") does not exist!  please check the path and try again.")
	wscript.quit
end if

do until objTextFile.AtEndOfStream
	redim Preserve strHosts(y)
	strHosts(y) = trim(objTextFile.Readline)
	y = y + 1
loop

objTextFile.Close

call log_it(VbCrLf & "checking " & y & " server(s)..." & VbCrLf)



' iterate server list 
for i = 0 to ubound(strHosts)

	infected = 0
	strhost = strHosts(i)
	call log_it("checking " & strhost)
	call log_it(" - pinging " & strhost & "...")
	retval = objPing.Run("ping -n 1 " &  strhost, 0, TRUE) 
 
	if retval = 0 then
		call log_it(" - successfully pinged " & strhost)
		if len(userid) > 0 then 
			if instr(1, userid, "\", 1) = 0 then
				userid = strhost & "\" & userid
			end if 	
		end if 

		call log_it(" - connecting to " & strhost & "...")
		call wmi_connect(strhost, _
						 userid, _
						 userpw, _
						 wmiconn, _
						 wmireg)


		call log_it(" - collecting system data for " & strhost)

		strQuery = "SELECT * " & _
				   "FROM Win32_OperatingSystem"

		set objOS = wmiconn.ExecQuery(strQuery)

		if objOS.count = 0 then
			call log_it(" - unable to retrieve the Windows system direcory name for " & strhost)
		else
			for each oOS in objOS
				call log_it(" - Windows system directory (" & oOS.SystemDirectory & ")")
				sysDir = oOS.SystemDirectory
			next 
		end if 


		call log_it(" - checking for infected registry entries (if present)")

		call log_it(" - checking " & strRunKey & "...")
		lRet = reg_funct("deletevalue", _
				         HKEY_LOCAL_MACHINE, _
					     strRunKey, _
				 	     strRunVal, _
					     "", _
					     wmiReg)

		if lRet = 0 then
			infected = 1
		end if 

		call log_it(" - checking " & strClsKey & "...")		
		lRet = reg_funct("getexpandedstring", _
				         HKEY_CLASSES_ROOT, _
					     strClsKey, _
				 	     "", _
					     strRegVal, _
					     wmiReg)
		
		if lRet = 0 then
			if strcomp(lcase(strRegVal), webChk, 1) <> 0 then				
				if strcomp(lcase(strRegVal), sysDir & "\" & webDLL, 1) <> 0 then	
				infected = 1
				call log_it(" - retrieved string incorrect (returned " & strRegval & "), correcting entry")	

					call reg_funct("setexpandedstring", _
								   HKEY_CLASSES_ROOT, _
								   strClsKey, _
								   "", _
								   webChk, _
								   wmiReg)
				else
					call log_it(" - the correct value is present (" & strRegVal & ")")		
				end if 
			else
				call log_it(" - the correct value is present (" & strRegVal & ")")
			end if 
		end if 


		call log_it(" - retrieving active process list...")		

		strQuery = "SELECT * " & _
				   "FROM Win32_Process "

		set objPids = wmiconn.ExecQuery(strQuery)
		
		if objPids.count = 0 then
			call log_it(" - no process ids were returned for " & strhost)
		else 
			call log_it(" - " & objPids.count & " process ids were returned for " & strhost)

			for each oPid in objPids
				'call log_it(" ")
				call log_it(" - checking " & oPid.Name & " (" & oPid.Handle & ")...")

				if instr(1, lcase(oPid.ExecutablePath), badEXE, 1) > 0 then
					infected = 1
					call log_it(" - " & badEXE & " found active in memory (" & oPid.Handle & "), terminating..")
					lRet = oPid.Terminate
					if lRet = 0 then
						call log_it(" - successfully terminated the " & badEXE & " process, deleting file...")
						call delete_file(oPid.ExecutablePath, _
										 wmiconn)
					else
						call log_it(" - error " & lRet & ": unable to terminate the " & badEXE & " process!")
					end if 					
				
				else
					strQuery = "ASSOCIATORS OF {Win32_Process.Handle=" & oPid.Handle & "} " & _
							   "WHERE AssocClass=CIM_ProcessExecutable " & _
							   "ResultClass=CIM_DataFile " & _ 	
							   "Role=Dependent " & _
							   "ResultRole=Antecedent"

					set objAnt = wmiconn.ExecQuery(strQuery)

					if objAnt.count = 0 then
						call log_it(" - no associated DLLs were returned for " & oPid.Name)
					else
						call log_it(" - " & objAnt.count & " associated DLL(s) returned for " & oPid.Name)
						for each oAnt in objAnt
							'call log_it("    * " & oAnt.Name)
							if instr(1, lcase(oAnt.Name), badDLL, 1) > 0 then
								infected = 1
								call log_it("    * " & oAnt.Name)
								call log_it(" - " & oPid.Name & " found with an open handle to " & badDLL & ", terminating..")
								lRet = oPid.Terminate
								if lRet = 0 then
									call log_it(" - successfully terminated the " & oPid.Name & " process, deleting file...")

									if instr(1, lcase(oPid.ExecutablePath), "explorer.exe", 1) > 0 then
										call log_it(" - exception process detected (EXPLORER.EXE), skipping file")
										call delete_file(sysDir & "\" & badDLL, _
														 wmiconn)
									else
										call log_it(" - attempting deletion of " & oPid.ExecutablePath & "...")
										call delete_file(oPid.ExecutablePath, _
														 wmiconn)								
									end if
								else
									call log_it(" - error " & lRet & ": unable to terminate the " & oPid.Name & " process!")
								end if 
							end if 

						next
					end If

					set objAnt = nothing

				end if

			next

		end if		
		
		set objPids = nothing	

		call log_it(" - checking for remaining infected file content (if present)")
		call delete_file(sysDir & "\" & badEXE, _
						 wmiconn)	
		call delete_file(sysDir & "\" & badDLL, _
						 wmiconn)	

	else 
		call log_it(" - unable to ping " & strhost & ", skipping host...")
		redim Preserve ping(c)
		ping(c) = strhost
		c = c + 1
	end if 

	if infected = 1 then
		redim Preserve icount(a)
		icount(a) = strhost 
		a = a + 1
		if reboot = 1 then
			call log_it(" - reboot option detected, rebooting " & strhost & "...")
			for each oOS in objOS
				oOS.Win32Shutdown(2)
			next
		end if 
	end if
	
	call log_it("check of " & strhost & " complete!" & VbCrLf)

	set wmiconn = nothing
	set wmireg  = nothing
	set objOS   = nothing
	sysDir      = ""

next 

' generate summary
call log_it (VbCrLf & "SUMMARY:" & VbCrLf)
call log_it(" - " & y & " server(s) checked")
call log_it(" - " & c & " unpingable hosts")
if c > 0 then 
	for d = 0 to ubound(ping)
		call log_it("     * " & ping(d))
	next
end if 

call log_it(" - " & a & " infected hosts detected")
if a > 0 then 
	for d = 0 to ubound(icount)
		call log_it("     * " & icount(d))
	next
end if 

call log_it(VbCrLf & "script completed at " & now & VbCrLf)

oLog.Close
wscript.quit


' log entries 
'________________________________________________________________________________________________________________
'
sub log_it (strData)
'________________________________________________________________________________________________________________
'
	wscript.echo strData
	oLog.Writeline strData

end sub

' multi-function WMI registry method
'________________________________________________________________________________________________________________
'
function reg_funct (objMeth, lHive, strKey, strVal, strRet, byRef objReg)
'________________________________________________________________________________________________________________
'
	dim objRHndl, lRet

	Set objRHndl = objReg.Get("StdRegProv")

	select case lcase(objMeth)

		case "getexpandedstring"
			lRet = objRHndl.GetExpandedStringValue (lHive, _
				   strKey, _
				   strVal, _
				   strRet)	
		
		case "setexpandedstring"
			lRet = objRHndl.SetExpandedStringValue (lHive, _
				   strKey, _
				   strVal, _
				   strRet)	

		case "getstring"
			lRet = objRHndl.GetStringValue (lHive, _
				   strKey, _
				   strVal, _
				   strRet)	

		case "setstring"
			lRet = objRHndl.SetStringValue (lHive, _
				   strKey, _
				   strVal, _
				   strRet)	

		case "deletevalue"
			lRet = objRHndl.DeleteValue (lHive, _
				   strKey, _
				   strVal)
		case else
			lRet = 5
	end select	

	if lRet = 0 then
		call log_it(" - successfully called '" & objMeth & "' for " & strKey & "\" & strVal)
	else
		if lRet = 2 then
			call log_it(" - " & strKey & "\" & strVal & " not found")
		else 
			call log_it(" - error " & lRet & ": unable to call '"_
					    & objMeth & "' for " & strKey & "\" & strVal)
		end if 
	end if 

	reg_funct = lRet

	set objRHndl = nothing


end function


' test for file existence, deleting if found
'________________________________________________________________________________________________________________
'
function delete_file (strFilePath, byRef objConn)
'________________________________________________________________________________________________________________
'
	dim objFile, oFile, badFile, strQry, strPath, lRet

	strPath = replace(strFilePath, "\", "\\")
	strQry = "SELECT * FROM CIM_DataFile WHERE Name = '" & strPath & "'"
	
	set objFile = objConn.ExecQuery(strQry)
	if objFile.count = 0 then		
		call log_it(" - file (" & strFilePath & ") not found")
	Else		
		call log_it(" - " & objFile.count & " instance(s) of " & strFilePath & " detected")
		for each oFile in objFile
			lRet = oFile.Delete
			if lRet = 0 then
				call log_it(" - " & strFilePath & " successfully deleted")
			else
				call log_it(" - error " & lRet & ": unable to delete " & strFilePath)
			end if 
		next
	End If

	set objFile = nothing						

End Function


' parse the passed in CLI options
'________________________________________________________________________________________________________________
'
sub parse_cli ()
'________________________________________________________________________________________________________________
'
    dim oArgs, i, lst
    set oArgs = wscript.Arguments

    if oArgs.Count = 0 then
        call cli_options
        exit sub
    end if

    while i < oArgs.Count
		'wscript.echo oArgs(i)
        select case lcase(oArgs(i))
			case "-f"
                i = i + 1
				if instr(oArgs(i), "-") then
					call cli_options
					exit sub
				else 
					srvlst = oArgs(i)
				end if 				
            case "-u"
                i = i + 1
				if instr(oArgs(i), "-") then
					call cli_options
					exit sub
				else 
					userid = oArgs(i)
				end if 
            case "-p"
                i = i + 1
				if instr(oArgs(i), "-") then
					call cli_options
					exit sub
				else 
					userpw = oArgs(i)
				end if 
            case "-r"
				reboot = 1
            case else
                call cli_options
                exit sub
        end select
        i = i + 1
    wend

end sub

' display the CLI syntax
'________________________________________________________________________________________________________________
'
sub cli_options ()
'________________________________________________________________________________________________________________
'
    wscript.echo ""
    wscript.echo "DOOMKILL.VBS: remotely remediate MyDoom infected machines"
    wscript.echo ""
    wscript.echo "SYNTAX:"
    wscript.echo "  cscript.exe doomkill.vbs [-F <server list>]" 
	wscript.echo "  [optional: [-U <logon account>] [-P <logon password>] [-R]"
    wscript.echo ""
    wscript.echo "PARAMETER SPECIFIERS:"
	wscript.echo ""
    wscript.echo "   -F <server list>      REQUIRED: full path to carriage return-delimited server list"
	wscript.echo "   -U <logon account>    OPTIONAL: supply alternate credentials to connect to server list"
	wscript.echo "                                   (If omitted, defaults to logged-on user's credentials)"
	wscript.echo "   -P <logon password>   OPTIONAL: supply alternate credential password"
	wscript.echo "                                   (If omitted, defaults to logged-on user's credentials)"
	wscript.echo "   -R                    OPTIONAL: Reboot the remote host if an infection has been cleaned" 
	wscript.echo ""
    wscript.echo "EXAMPLES:"
	wscript.echo ""
    wscript.echo "  cscript.exe doomkill.vbs -F c:\servers.txt -U DOMAIN\userid -P secret -R"
	wscript.echo "  - runs against c:\servers.txt using the DOMAIN\userid & password, reboots infected hosts"
	wscript.echo ""
    wscript.echo "  cscript.exe doomkill.vbs -F c:\servers.txt -R"
	wscript.echo "  - runs against c:\servers.txt with default credentials, reboots infected hosts"
	wscript.echo ""
    wscript.echo "  cscript.exe doomkill.vbs -F c:\servers.txt"
	wscript.echo "  - runs against c:\servers.txt with default credentials, no reboot"
	wscript.echo ""

	wscript.quit

end sub 

' create a WMI-based connection to a target server
'________________________________________________________________________________________________________________
'
function wmi_connect (strWksta, strUsr, strPwd, byRef objWmiCon, byRef objRegCon)
'________________________________________________________________________________________________________________
'
	dim objWbemLocator
	set objWbemLocator = CreateObject("WbemScripting.SWbemLocator")

	objWbemLocator.Security_.ImpersonationLevel = 3
	objWbemLocator.Security_.AuthenticationLevel = 2
	'objWbemLocator.Security_.Privileges.AddAsString "SeDebugPrivilege"
	objWbemLocator.Security_.Privileges.AddAsString "SeSecurityPrivilege"
	
	if len(strUsr) = 0 then	
		set objWmiCon = objwbemLocator.ConnectServer _
						(strWksta, _
						"root\cimv2")

		set objRegCon = objwbemLocator.ConnectServer _
						(strWksta, _
						"root\default")
	else 
		set objWmiCon = objwbemLocator.ConnectServer _
						(strWksta, _
						"root\cimv2", _
						strUsr, _
						strPwd)

		set objRegCon = objwbemLocator.ConnectServer _
						(strWksta, _
						"root\default", _
						strUsr, _
						strPwd)
	end if 

	set objWbemLocator = Nothing
	
end function

